/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.R;

final class GifViewUtils {
    static final String ANDROID_NS = "http://schemas.android.com/apk/res/android";
    static final List<String> SUPPORTED_RESOURCE_TYPE_NAMES = Arrays.asList("raw", "drawable", "mipmap");

    private GifViewUtils() {
    }

    static float getDensityScale(Resources resources, int n) {
        TypedValue typedValue = new TypedValue();
        resources.getValue(n, typedValue, true);
        n = typedValue.density;
        if (n == 0) {
            n = 160;
        } else if (n == 65535) {
            n = 0;
        }
        int n2 = resources.getDisplayMetrics().densityDpi;
        if (n > 0 && n2 > 0) {
            return (float)n2 / (float)n;
        }
        return 1.0f;
    }

    private static int getResourceId(ImageView imageView, AttributeSet object, boolean bl) {
        String string2 = bl ? "src" : "background";
        int n = object.getAttributeResourceValue(ANDROID_NS, string2, 0);
        if (n > 0 && SUPPORTED_RESOURCE_TYPE_NAMES.contains(object = imageView.getResources().getResourceTypeName(n)) && !GifViewUtils.setResource(imageView, bl, n)) {
            return n;
        }
        return 0;
    }

    static InitResult initImageView(ImageView imageView, AttributeSet attributeSet, int n, int n2) {
        if (attributeSet != null && !imageView.isInEditMode()) {
            return new InitResult(GifViewUtils.getResourceId(imageView, attributeSet, true), GifViewUtils.getResourceId(imageView, attributeSet, false), GifViewUtils.isFreezingAnimation((View)imageView, attributeSet, n, n2));
        }
        return new InitResult(0, 0, false);
    }

    static boolean isFreezingAnimation(View view, AttributeSet attributeSet, int n, int n2) {
        view = view.getContext().obtainStyledAttributes(attributeSet, R.styleable.GifView, n, n2);
        boolean bl = view.getBoolean(R.styleable.GifView_freezesAnimation, false);
        view.recycle();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean setGifImageUri(ImageView imageView, Uri uri) {
        if (uri == null) return false;
        try {
            GifDrawable gifDrawable = new GifDrawable(imageView.getContext().getContentResolver(), uri);
            imageView.setImageDrawable((Drawable)gifDrawable);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean setResource(ImageView imageView, boolean bl, int n) {
        Resources resources = imageView.getResources();
        if (resources == null) return false;
        try {
            GifDrawable gifDrawable = new GifDrawable(resources, n);
            if (bl) {
                imageView.setImageDrawable((Drawable)gifDrawable);
                return true;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                imageView.setBackground((Drawable)gifDrawable);
                return true;
            }
            imageView.setBackgroundDrawable((Drawable)gifDrawable);
            return true;
        }
        catch (Resources.NotFoundException | IOException throwable) {
            return false;
        }
    }

    static class InitResult {
        final int mBackgroundResId;
        final boolean mFreezesAnimation;
        final int mSourceResId;

        InitResult(int n, int n2, boolean bl) {
            this.mSourceResId = n;
            this.mBackgroundResId = n2;
            this.mFreezesAnimation = bl;
        }
    }
}

