/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifIOException;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifOptions;

public abstract class InputSource {
    InputSource() {
    }

    final GifDrawable build(GifDrawable gifDrawable, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, boolean bl, GifOptions gifOptions) throws IOException {
        GifInfoHandle gifInfoHandle = this.open();
        gifInfoHandle.setOptions(gifOptions.inSampleSize, gifOptions.inIsOpaque);
        return new GifDrawable(gifInfoHandle, gifDrawable, scheduledThreadPoolExecutor, bl);
    }

    abstract GifInfoHandle open() throws IOException;

    public static class AssetFileDescriptorSource
    extends InputSource {
        private final AssetFileDescriptor mAssetFileDescriptor;

        public AssetFileDescriptorSource(AssetFileDescriptor assetFileDescriptor) {
            this.mAssetFileDescriptor = assetFileDescriptor;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.mAssetFileDescriptor, false);
        }
    }

    public static final class AssetSource
    extends InputSource {
        private final AssetManager mAssetManager;
        private final String mAssetName;

        public AssetSource(AssetManager assetManager, String string2) {
            this.mAssetManager = assetManager;
            this.mAssetName = string2;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.mAssetManager.openFd(this.mAssetName), false);
        }
    }

    public static final class ByteArraySource
    extends InputSource {
        private final byte[] bytes;

        public ByteArraySource(byte[] byArray) {
            this.bytes = byArray;
        }

        @Override
        GifInfoHandle open() throws GifIOException {
            return new GifInfoHandle(this.bytes, false);
        }
    }

    public static final class DirectByteBufferSource
    extends InputSource {
        private final ByteBuffer byteBuffer;

        public DirectByteBufferSource(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        GifInfoHandle open() throws GifIOException {
            return new GifInfoHandle(this.byteBuffer, false);
        }
    }

    public static final class FileDescriptorSource
    extends InputSource {
        private final FileDescriptor mFd;

        public FileDescriptorSource(FileDescriptor fileDescriptor) {
            this.mFd = fileDescriptor;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.mFd, false);
        }
    }

    public static final class FileSource
    extends InputSource {
        private final String mPath;

        public FileSource(File file) {
            this.mPath = file.getPath();
        }

        public FileSource(String string2) {
            this.mPath = string2;
        }

        @Override
        GifInfoHandle open() throws GifIOException {
            return new GifInfoHandle(this.mPath, false);
        }
    }

    public static final class InputStreamSource
    extends InputSource {
        private final InputStream inputStream;

        public InputStreamSource(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.inputStream, false);
        }
    }

    public static class ResourcesSource
    extends InputSource {
        private final int mResourceId;
        private final Resources mResources;

        public ResourcesSource(Resources resources, int n) {
            this.mResources = resources;
            this.mResourceId = n;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.mResources.openRawResourceFd(this.mResourceId), false);
        }
    }

    public static final class UriSource
    extends InputSource {
        private final ContentResolver mContentResolver;
        private final Uri mUri;

        public UriSource(ContentResolver contentResolver, Uri uri) {
            this.mContentResolver = contentResolver;
            this.mUri = uri;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return GifInfoHandle.openUri(this.mContentResolver, this.mUri, false);
        }
    }
}

