/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.graphics.drawable.Drawable;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;

public class MultiCallback
implements Drawable.Callback {
    private final CopyOnWriteArrayList<CallbackWeakReference> mCallbacks = new CopyOnWriteArrayList();
    private final boolean mUseViewInvalidate;

    public MultiCallback() {
        this(false);
    }

    public MultiCallback(boolean bl) {
        this.mUseViewInvalidate = bl;
    }

    public void addView(Drawable.Callback callback) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference callbackWeakReference = this.mCallbacks.get(i);
            if ((Drawable.Callback)callbackWeakReference.get() != null) continue;
            this.mCallbacks.remove(callbackWeakReference);
        }
        this.mCallbacks.addIfAbsent(new CallbackWeakReference(callback));
    }

    public void invalidateDrawable(Drawable drawable2) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference callbackWeakReference = this.mCallbacks.get(i);
            Drawable.Callback callback = (Drawable.Callback)callbackWeakReference.get();
            if (callback != null) {
                if (this.mUseViewInvalidate && callback instanceof View) {
                    ((View)callback).invalidate();
                    continue;
                }
                callback.invalidateDrawable(drawable2);
                continue;
            }
            this.mCallbacks.remove(callbackWeakReference);
        }
    }

    public void removeView(Drawable.Callback callback) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference callbackWeakReference = this.mCallbacks.get(i);
            Drawable.Callback callback2 = (Drawable.Callback)callbackWeakReference.get();
            if (callback2 != null && callback2 != callback) continue;
            this.mCallbacks.remove(callbackWeakReference);
        }
    }

    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference callbackWeakReference = this.mCallbacks.get(i);
            Drawable.Callback callback = (Drawable.Callback)callbackWeakReference.get();
            if (callback != null) {
                callback.scheduleDrawable(drawable2, runnable, l);
                continue;
            }
            this.mCallbacks.remove(callbackWeakReference);
        }
    }

    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference callbackWeakReference = this.mCallbacks.get(i);
            Drawable.Callback callback = (Drawable.Callback)callbackWeakReference.get();
            if (callback != null) {
                callback.unscheduleDrawable(drawable2, runnable);
                continue;
            }
            this.mCallbacks.remove(callbackWeakReference);
        }
    }

    static final class CallbackWeakReference
    extends WeakReference<Drawable.Callback> {
        CallbackWeakReference(Drawable.Callback callback) {
            super(callback);
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                if (this.get() != ((CallbackWeakReference)object).get()) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            Drawable.Callback callback = (Drawable.Callback)this.get();
            int n = callback != null ? callback.hashCode() : 0;
            return n;
        }
    }
}

