/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.Context;
import android.os.Build;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ReLinker {
    private static final int COPY_BUFFER_SIZE = 8192;
    private static final String LIB_DIR = "lib";
    private static final int MAX_TRIES = 5;

    private ReLinker() {
    }

    private static void clearOldLibraryFiles(File fileArray, FilenameFilter filenameFilter) {
        if ((fileArray = fileArray.getParentFile().listFiles(filenameFilter)) != null) {
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                fileArray[i].delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void closeSilently(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    private static ZipEntry findLibraryEntry(String string2, ZipFile zipFile) {
        if (Build.VERSION.SDK_INT >= 21) {
            String[] stringArray = Build.SUPPORTED_ABIS;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                ZipEntry zipEntry = ReLinker.getEntry(string2, zipFile, stringArray[i]);
                if (zipEntry == null) continue;
                return zipEntry;
            }
        }
        return ReLinker.getEntry(string2, zipFile, Build.CPU_ABI);
    }

    private static ZipEntry getEntry(String string2, ZipFile zipFile, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("lib/");
        stringBuilder.append(string3);
        stringBuilder.append("/");
        stringBuilder.append(string2);
        return zipFile.getEntry(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void loadLibrary(Context context, String string2) {
        string2 = System.mapLibraryName(string2);
        synchronized (ReLinker.class) {
            System.load(ReLinker.unpackLibrary(context, string2).getAbsolutePath());
            return;
        }
    }

    private static ZipFile openZipFile(File file) {
        Object object;
        block4: {
            for (int i = 0; i < 5; ++i) {
                try {
                    object = new ZipFile(file, 1);
                    break block4;
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            object = null;
        }
        if (object != null) {
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Could not open APK file: ");
        ((StringBuilder)object).append(file.getAbsolutePath());
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    private static void setFilePermissions(File file) {
        file.setReadable(true, false);
        file.setExecutable(true, false);
        file.setWritable(true);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File unpackLibrary(Context object, String object2) {
        void var0_15;
        ZipFile zipFile;
        Comparable<StringBuilder> comparable;
        block33: {
            ZipFile zipFile2;
            block29: {
                int n = 0;
                Object object3 = object.getDir(LIB_DIR, 0);
                comparable = new StringBuilder();
                ((StringBuilder)comparable).append((String)((Object)zipFile));
                ((StringBuilder)comparable).append("1.1.17");
                comparable = new File((File)object3, ((StringBuilder)comparable).toString());
                if (((File)comparable).isFile()) {
                    return comparable;
                }
                Object object4 = object.getCacheDir();
                object3 = new StringBuilder();
                ((StringBuilder)object3).append((String)((Object)zipFile));
                ((StringBuilder)object3).append("1.1.17");
                File file = new File((File)object4, ((StringBuilder)object3).toString());
                if (file.isFile()) {
                    return file;
                }
                object3 = new FilenameFilter((String)((Object)zipFile)){
                    final /* synthetic */ String val$libName;
                    {
                        this.val$libName = string2;
                    }

                    @Override
                    public boolean accept(File file, String string2) {
                        return string2.startsWith(this.val$libName);
                    }
                };
                ReLinker.clearOldLibraryFiles(comparable, (FilenameFilter)object3);
                ReLinker.clearOldLibraryFiles(file, (FilenameFilter)object3);
                File file2 = new File(object.getApplicationInfo().sourceDir);
                zipFile2 = ReLinker.openZipFile(file2);
                while (true) {
                    void var0_11;
                    int n2;
                    block31: {
                        void var0_8;
                        block30: {
                            block32: {
                                n2 = n + 1;
                                if (n >= 5) break block29;
                                ZipEntry zipEntry = ReLinker.findLibraryEntry((String)((Object)zipFile), zipFile2);
                                if (zipEntry == null) break;
                                InputStream inputStream = zipFile2.getInputStream(zipEntry);
                                object3 = new FileOutputStream((File)comparable);
                                ReLinker.copy(inputStream, (OutputStream)object3);
                                ReLinker.closeSilently(inputStream);
                                ReLinker.closeSilently((Closeable)object3);
                                ReLinker.setFilePermissions(comparable);
                                break block29;
                                catch (Throwable throwable) {
                                    break block30;
                                }
                                catch (IOException iOException) {
                                    object4 = inputStream;
                                    Object object5 = object3;
                                    break block31;
                                }
                                catch (Throwable throwable) {
                                    break block32;
                                }
                                catch (IOException iOException) {
                                    object3 = null;
                                    object4 = inputStream;
                                    Object object6 = object3;
                                    break block31;
                                }
                                catch (Throwable throwable) {
                                    Object var0_7 = null;
                                }
                            }
                            object3 = null;
                        }
                        ReLinker.closeSilently((Closeable)var0_8);
                        ReLinker.closeSilently((Closeable)object3);
                        throw zipFile;
                        catch (IOException iOException) {
                            object4 = null;
                            File file3 = object4;
                        }
                    }
                    if (n2 > 2) {
                        comparable = file;
                    }
                    ReLinker.closeSilently((Closeable)object4);
                    ReLinker.closeSilently((Closeable)var0_11);
                    n = n2;
                    continue;
                    break;
                }
                try {
                    comparable = new Comparable<StringBuilder>();
                    ((StringBuilder)comparable).append("Library ");
                    ((StringBuilder)comparable).append((String)((Object)zipFile));
                    ((StringBuilder)comparable).append(" for supported ABIs not found in APK file");
                    IllegalStateException illegalStateException = new IllegalStateException(((StringBuilder)comparable).toString());
                    throw illegalStateException;
                }
                catch (Throwable throwable) {
                    zipFile = zipFile2;
                }
                break block33;
            }
            if (zipFile2 != null) {
                zipFile2.close();
            }
            return comparable;
            catch (Throwable throwable) {
                zipFile = null;
            }
        }
        if (zipFile != null) {
            zipFile.close();
        }
        throw var0_15;
        catch (IOException iOException) {
            return comparable;
        }
        catch (IOException iOException) {
            throw var0_15;
        }
    }
}

