/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif.transforms;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import pl.droidsonroids.gif.transforms.Transform;

public class CornerRadiusTransform
implements Transform {
    private float mCornerRadius;
    private final RectF mDstRectF = new RectF();
    private Shader mShader;

    public CornerRadiusTransform(float f) {
        this.setCornerRadius(f);
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    @Override
    public void onBoundsChange(Rect rect) {
        this.mDstRectF.set(rect);
        this.mShader = null;
    }

    @Override
    public void onDraw(Canvas canvas, Paint paint, Bitmap bitmap) {
        if (this.mCornerRadius == 0.0f) {
            canvas.drawBitmap(bitmap, null, this.mDstRectF, paint);
            return;
        }
        if (this.mShader == null) {
            this.mShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            Matrix matrix = new Matrix();
            matrix.setTranslate(this.mDstRectF.left, this.mDstRectF.top);
            matrix.preScale(this.mDstRectF.width() / (float)bitmap.getWidth(), this.mDstRectF.height() / (float)bitmap.getHeight());
            this.mShader.setLocalMatrix(matrix);
        }
        paint.setShader(this.mShader);
        bitmap = this.mDstRectF;
        float f = this.mCornerRadius;
        canvas.drawRoundRect((RectF)bitmap, f, f, paint);
    }

    public void setCornerRadius(float f) {
        if ((f = Math.max(0.0f, f)) == this.mCornerRadius) {
            return;
        }
        this.mCornerRadius = f;
        this.mShader = null;
    }
}

