/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import pub.devrel.easypermissions.AppSettingsDialogHolderActivity;
import pub.devrel.easypermissions.R;

public class AppSettingsDialog
implements Parcelable {
    public static final Parcelable.Creator<AppSettingsDialog> CREATOR = new Parcelable.Creator<AppSettingsDialog>(){

        public AppSettingsDialog createFromParcel(Parcel parcel) {
            return new AppSettingsDialog(parcel);
        }

        public AppSettingsDialog[] newArray(int n) {
            return new AppSettingsDialog[n];
        }
    };
    public static final int DEFAULT_SETTINGS_REQ_CODE = 16061;
    static final String EXTRA_APP_SETTINGS = "extra_app_settings";
    private static final String TAG = "EasyPermissions";
    private Object mActivityOrFragment;
    private Context mContext;
    private final int mIntentFlags;
    private final String mNegativeButtonText;
    private final String mPositiveButtonText;
    private final String mRationale;
    private final int mRequestCode;
    private final int mThemeResId;
    private final String mTitle;

    private AppSettingsDialog(Parcel parcel) {
        this.mThemeResId = parcel.readInt();
        this.mRationale = parcel.readString();
        this.mTitle = parcel.readString();
        this.mPositiveButtonText = parcel.readString();
        this.mNegativeButtonText = parcel.readString();
        this.mRequestCode = parcel.readInt();
        this.mIntentFlags = parcel.readInt();
    }

    private AppSettingsDialog(Object object, int n, String string2, String string3, String string4, String string5, int n2, int n3) {
        this.setActivityOrFragment(object);
        this.mThemeResId = n;
        this.mRationale = string2;
        this.mTitle = string3;
        this.mPositiveButtonText = string4;
        this.mNegativeButtonText = string5;
        this.mRequestCode = n2;
        this.mIntentFlags = n3;
    }

    static AppSettingsDialog fromIntent(Intent intent, Activity activity) {
        AppSettingsDialog appSettingsDialog = (AppSettingsDialog)intent.getParcelableExtra(EXTRA_APP_SETTINGS);
        Object object = appSettingsDialog;
        if (appSettingsDialog == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Intent contains null value for EXTRA_APP_SETTINGS: intent=");
            ((StringBuilder)object).append(intent);
            ((StringBuilder)object).append(", extras=");
            ((StringBuilder)object).append(intent.getExtras());
            Log.e((String)TAG, (String)((StringBuilder)object).toString());
            object = new Builder(activity).build();
        }
        ((AppSettingsDialog)object).setActivityOrFragment(activity);
        return object;
    }

    private void setActivityOrFragment(Object object) {
        block4: {
            block3: {
                block2: {
                    this.mActivityOrFragment = object;
                    if (!(object instanceof Activity)) break block2;
                    this.mContext = (Activity)object;
                    break block3;
                }
                if (!(object instanceof Fragment)) break block4;
                this.mContext = ((Fragment)object).getContext();
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown object: ");
        stringBuilder.append(object);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private void startForResult(Intent intent) {
        Object object = this.mActivityOrFragment;
        if (object instanceof Activity) {
            ((Activity)object).startActivityForResult(intent, this.mRequestCode);
        } else if (object instanceof Fragment) {
            ((Fragment)object).startActivityForResult(intent, this.mRequestCode);
        }
    }

    public int describeContents() {
        return 0;
    }

    int getIntentFlags() {
        return this.mIntentFlags;
    }

    public void show() {
        this.startForResult(AppSettingsDialogHolderActivity.createShowDialogIntent(this.mContext, this));
    }

    AlertDialog showDialog(DialogInterface.OnClickListener onClickListener, DialogInterface.OnClickListener onClickListener2) {
        AlertDialog.Builder builder = this.mThemeResId != -1 ? new AlertDialog.Builder(this.mContext, this.mThemeResId) : new AlertDialog.Builder(this.mContext);
        return builder.setCancelable(false).setTitle((CharSequence)this.mTitle).setMessage((CharSequence)this.mRationale).setPositiveButton((CharSequence)this.mPositiveButtonText, onClickListener).setNegativeButton((CharSequence)this.mNegativeButtonText, onClickListener2).show();
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mThemeResId);
        parcel.writeString(this.mRationale);
        parcel.writeString(this.mTitle);
        parcel.writeString(this.mPositiveButtonText);
        parcel.writeString(this.mNegativeButtonText);
        parcel.writeInt(this.mRequestCode);
        parcel.writeInt(this.mIntentFlags);
    }

    public static class Builder {
        private final Object mActivityOrFragment;
        private final Context mContext;
        private String mNegativeButtonText;
        private boolean mOpenInNewTask = false;
        private String mPositiveButtonText;
        private String mRationale;
        private int mRequestCode = -1;
        private int mThemeResId = -1;
        private String mTitle;

        public Builder(Activity activity) {
            this.mActivityOrFragment = activity;
            this.mContext = activity;
        }

        public Builder(Fragment fragment) {
            this.mActivityOrFragment = fragment;
            this.mContext = fragment.getContext();
        }

        public AppSettingsDialog build() {
            String string2 = TextUtils.isEmpty((CharSequence)this.mRationale) ? this.mContext.getString(R.string.rationale_ask_again) : this.mRationale;
            this.mRationale = string2;
            string2 = TextUtils.isEmpty((CharSequence)this.mTitle) ? this.mContext.getString(R.string.title_settings_dialog) : this.mTitle;
            this.mTitle = string2;
            string2 = TextUtils.isEmpty((CharSequence)this.mPositiveButtonText) ? this.mContext.getString(17039370) : this.mPositiveButtonText;
            this.mPositiveButtonText = string2;
            string2 = TextUtils.isEmpty((CharSequence)this.mNegativeButtonText) ? this.mContext.getString(0x1040000) : this.mNegativeButtonText;
            this.mNegativeButtonText = string2;
            int n = this.mRequestCode;
            if (n <= 0) {
                n = 16061;
            }
            this.mRequestCode = n;
            n = this.mOpenInNewTask ? 0x10000000 : 0;
            return new AppSettingsDialog(this.mActivityOrFragment, this.mThemeResId, this.mRationale, this.mTitle, this.mPositiveButtonText, this.mNegativeButtonText, this.mRequestCode, n);
        }

        public Builder setNegativeButton(int n) {
            this.mNegativeButtonText = this.mContext.getString(n);
            return this;
        }

        public Builder setNegativeButton(String string2) {
            this.mNegativeButtonText = string2;
            return this;
        }

        public Builder setOpenInNewTask(boolean bl) {
            this.mOpenInNewTask = bl;
            return this;
        }

        public Builder setPositiveButton(int n) {
            this.mPositiveButtonText = this.mContext.getString(n);
            return this;
        }

        public Builder setPositiveButton(String string2) {
            this.mPositiveButtonText = string2;
            return this;
        }

        public Builder setRationale(int n) {
            this.mRationale = this.mContext.getString(n);
            return this;
        }

        public Builder setRationale(String string2) {
            this.mRationale = string2;
            return this;
        }

        public Builder setRequestCode(int n) {
            this.mRequestCode = n;
            return this;
        }

        public Builder setThemeResId(int n) {
            this.mThemeResId = n;
            return this;
        }

        public Builder setTitle(int n) {
            this.mTitle = this.mContext.getString(n);
            return this;
        }

        public Builder setTitle(String string2) {
            this.mTitle = string2;
            return this;
        }
    }
}

