/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import pub.devrel.easypermissions.AfterPermissionGranted;
import pub.devrel.easypermissions.PermissionRequest;
import pub.devrel.easypermissions.helper.PermissionHelper;

public class EasyPermissions {
    private static final String TAG = "EasyPermissions";

    public static boolean hasPermissions(Context context, String ... stringArray) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        if (context != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (ContextCompat.checkSelfPermission((Context)context, (String)stringArray[i]) == 0) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Can't check permissions for null context");
    }

    private static boolean isUsingAndroidAnnotations(Object object) {
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return false;
        }
        try {
            boolean bl = Class.forName("org.androidannotations.api.view.HasViews").isInstance(object);
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static void notifyAlreadyHasPermissions(Object object, int n, String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = 0;
        }
        EasyPermissions.onRequestPermissionsResult(n, stringArray, nArray, object);
    }

    public static void onRequestPermissionsResult(int n, String[] object, int[] nArray, Object ... objectArray) {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n3 = 0;
        for (n2 = 0; n2 < ((String[])object).length; ++n2) {
            String string2 = object[n2];
            if (nArray[n2] == 0) {
                arrayList.add(string2);
                continue;
            }
            arrayList2.add(string2);
        }
        int n4 = objectArray.length;
        for (n2 = n3; n2 < n4; ++n2) {
            object = objectArray[n2];
            if (!arrayList.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsGranted(n, arrayList);
            }
            if (!arrayList2.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsDenied(n, arrayList2);
            }
            if (arrayList.isEmpty() || !arrayList2.isEmpty()) continue;
            EasyPermissions.runAnnotatedMethods(object, n);
        }
    }

    public static boolean permissionPermanentlyDenied(Activity activity, String string2) {
        return PermissionHelper.newInstance(activity).permissionPermanentlyDenied(string2);
    }

    public static boolean permissionPermanentlyDenied(Fragment fragment, String string2) {
        return PermissionHelper.newInstance(fragment).permissionPermanentlyDenied(string2);
    }

    public static void requestPermissions(Activity activity, String string2, int n, String ... stringArray) {
        EasyPermissions.requestPermissions(new PermissionRequest.Builder(activity, n, stringArray).setRationale(string2).build());
    }

    public static void requestPermissions(Fragment fragment, String string2, int n, String ... stringArray) {
        EasyPermissions.requestPermissions(new PermissionRequest.Builder(fragment, n, stringArray).setRationale(string2).build());
    }

    public static void requestPermissions(PermissionRequest permissionRequest) {
        if (EasyPermissions.hasPermissions(permissionRequest.getHelper().getContext(), permissionRequest.getPerms())) {
            EasyPermissions.notifyAlreadyHasPermissions(permissionRequest.getHelper().getHost(), permissionRequest.getRequestCode(), permissionRequest.getPerms());
            return;
        }
        permissionRequest.getHelper().requestPermissions(permissionRequest.getRationale(), permissionRequest.getPositiveButtonText(), permissionRequest.getNegativeButtonText(), permissionRequest.getTheme(), permissionRequest.getRequestCode(), permissionRequest.getPerms());
    }

    private static void runAnnotatedMethods(Object object, int n) {
        Method[] methodArray;
        Object object2 = methodArray = object.getClass();
        if (EasyPermissions.isUsingAndroidAnnotations(object)) {
            object2 = methodArray.getSuperclass();
        }
        while (object2 != null) {
            for (Method method : object2.getDeclaredMethods()) {
                AfterPermissionGranted afterPermissionGranted = method.getAnnotation(AfterPermissionGranted.class);
                if (afterPermissionGranted == null || afterPermissionGranted.value() != n) continue;
                if (method.getParameterTypes().length <= 0) {
                    try {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        method.invoke(object, new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Log.e((String)TAG, (String)"runDefaultMethod:InvocationTargetException", (Throwable)invocationTargetException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Log.e((String)TAG, (String)"runDefaultMethod:IllegalAccessException", (Throwable)illegalAccessException);
                    }
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Cannot execute method ");
                ((StringBuilder)object).append(method.getName());
                ((StringBuilder)object).append(" because it is non-void method and/or has input parameters.");
                throw new RuntimeException(((StringBuilder)object).toString());
            }
            object2 = object2.getSuperclass();
        }
    }

    public static boolean somePermissionDenied(Activity activity, String ... stringArray) {
        return PermissionHelper.newInstance(activity).somePermissionDenied(stringArray);
    }

    public static boolean somePermissionDenied(Fragment fragment, String ... stringArray) {
        return PermissionHelper.newInstance(fragment).somePermissionDenied(stringArray);
    }

    public static boolean somePermissionPermanentlyDenied(Activity activity, List<String> list) {
        return PermissionHelper.newInstance(activity).somePermissionPermanentlyDenied(list);
    }

    public static boolean somePermissionPermanentlyDenied(Fragment fragment, List<String> list) {
        return PermissionHelper.newInstance(fragment).somePermissionPermanentlyDenied(list);
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionsDenied(int var1, List<String> var2);

        public void onPermissionsGranted(int var1, List<String> var2);
    }

    public static interface RationaleCallbacks {
        public void onRationaleAccepted(int var1);

        public void onRationaleDenied(int var1);
    }
}

