/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions;

import android.app.Activity;
import androidx.fragment.app.Fragment;
import java.util.Arrays;
import pub.devrel.easypermissions.R;
import pub.devrel.easypermissions.helper.PermissionHelper;

public final class PermissionRequest {
    private final PermissionHelper mHelper;
    private final String mNegativeButtonText;
    private final String[] mPerms;
    private final String mPositiveButtonText;
    private final String mRationale;
    private final int mRequestCode;
    private final int mTheme;

    private PermissionRequest(PermissionHelper permissionHelper, String[] stringArray, int n, String string2, String string3, String string4, int n2) {
        this.mHelper = permissionHelper;
        this.mPerms = (String[])stringArray.clone();
        this.mRequestCode = n;
        this.mRationale = string2;
        this.mPositiveButtonText = string3;
        this.mNegativeButtonText = string4;
        this.mTheme = n2;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (PermissionRequest)object;
            if (!Arrays.equals(this.mPerms, ((PermissionRequest)object).mPerms) || this.mRequestCode != ((PermissionRequest)object).mRequestCode) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public PermissionHelper getHelper() {
        return this.mHelper;
    }

    public String getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    public String[] getPerms() {
        return (String[])this.mPerms.clone();
    }

    public String getPositiveButtonText() {
        return this.mPositiveButtonText;
    }

    public String getRationale() {
        return this.mRationale;
    }

    public int getRequestCode() {
        return this.mRequestCode;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mPerms) * 31 + this.mRequestCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PermissionRequest{mHelper=");
        stringBuilder.append(this.mHelper);
        stringBuilder.append(", mPerms=");
        stringBuilder.append(Arrays.toString(this.mPerms));
        stringBuilder.append(", mRequestCode=");
        stringBuilder.append(this.mRequestCode);
        stringBuilder.append(", mRationale='");
        stringBuilder.append(this.mRationale);
        stringBuilder.append('\'');
        stringBuilder.append(", mPositiveButtonText='");
        stringBuilder.append(this.mPositiveButtonText);
        stringBuilder.append('\'');
        stringBuilder.append(", mNegativeButtonText='");
        stringBuilder.append(this.mNegativeButtonText);
        stringBuilder.append('\'');
        stringBuilder.append(", mTheme=");
        stringBuilder.append(this.mTheme);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final PermissionHelper mHelper;
        private String mNegativeButtonText;
        private final String[] mPerms;
        private String mPositiveButtonText;
        private String mRationale;
        private final int mRequestCode;
        private int mTheme = -1;

        public Builder(Activity activity, int n, String ... stringArray) {
            this.mHelper = PermissionHelper.newInstance(activity);
            this.mRequestCode = n;
            this.mPerms = stringArray;
        }

        public Builder(Fragment fragment, int n, String ... stringArray) {
            this.mHelper = PermissionHelper.newInstance(fragment);
            this.mRequestCode = n;
            this.mPerms = stringArray;
        }

        public PermissionRequest build() {
            if (this.mRationale == null) {
                this.mRationale = this.mHelper.getContext().getString(R.string.rationale_ask);
            }
            if (this.mPositiveButtonText == null) {
                this.mPositiveButtonText = this.mHelper.getContext().getString(17039370);
            }
            if (this.mNegativeButtonText == null) {
                this.mNegativeButtonText = this.mHelper.getContext().getString(0x1040000);
            }
            return new PermissionRequest(this.mHelper, this.mPerms, this.mRequestCode, this.mRationale, this.mPositiveButtonText, this.mNegativeButtonText, this.mTheme);
        }

        public Builder setNegativeButtonText(int n) {
            this.mNegativeButtonText = this.mHelper.getContext().getString(n);
            return this;
        }

        public Builder setNegativeButtonText(String string2) {
            this.mNegativeButtonText = string2;
            return this;
        }

        public Builder setPositiveButtonText(int n) {
            this.mPositiveButtonText = this.mHelper.getContext().getString(n);
            return this;
        }

        public Builder setPositiveButtonText(String string2) {
            this.mPositiveButtonText = string2;
            return this;
        }

        public Builder setRationale(int n) {
            this.mRationale = this.mHelper.getContext().getString(n);
            return this;
        }

        public Builder setRationale(String string2) {
            this.mRationale = string2;
            return this;
        }

        public Builder setTheme(int n) {
            this.mTheme = n;
            return this;
        }
    }
}

