/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions.helper;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import java.util.List;
import pub.devrel.easypermissions.helper.ActivityPermissionHelper;
import pub.devrel.easypermissions.helper.AppCompatActivityPermissionsHelper;
import pub.devrel.easypermissions.helper.LowApiPermissionsHelper;
import pub.devrel.easypermissions.helper.SupportFragmentPermissionHelper;

public abstract class PermissionHelper<T> {
    private T mHost;

    public PermissionHelper(T t) {
        this.mHost = t;
    }

    public static PermissionHelper<? extends Activity> newInstance(Activity activity) {
        if (Build.VERSION.SDK_INT < 23) {
            return new LowApiPermissionsHelper<Activity>(activity);
        }
        if (activity instanceof AppCompatActivity) {
            return new AppCompatActivityPermissionsHelper((AppCompatActivity)activity);
        }
        return new ActivityPermissionHelper(activity);
    }

    public static PermissionHelper<Fragment> newInstance(Fragment fragment) {
        if (Build.VERSION.SDK_INT < 23) {
            return new LowApiPermissionsHelper<Fragment>(fragment);
        }
        return new SupportFragmentPermissionHelper(fragment);
    }

    private boolean shouldShowRationale(String ... stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.shouldShowRequestPermissionRationale(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public abstract void directRequestPermissions(int var1, String ... var2);

    public abstract Context getContext();

    public T getHost() {
        return this.mHost;
    }

    public boolean permissionPermanentlyDenied(String string2) {
        return this.shouldShowRequestPermissionRationale(string2) ^ true;
    }

    public void requestPermissions(String string2, String string3, String string4, int n, int n2, String ... stringArray) {
        if (this.shouldShowRationale(stringArray)) {
            this.showRequestPermissionRationale(string2, string3, string4, n, n2, stringArray);
        } else {
            this.directRequestPermissions(n2, stringArray);
        }
    }

    public abstract boolean shouldShowRequestPermissionRationale(String var1);

    public abstract void showRequestPermissionRationale(String var1, String var2, String var3, int var4, int var5, String ... var6);

    public boolean somePermissionDenied(String ... stringArray) {
        return this.shouldShowRationale(stringArray);
    }

    public boolean somePermissionPermanentlyDenied(List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!this.permissionPermanentlyDenied((String)object.next())) continue;
            return true;
        }
        return false;
    }
}

