/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import kotlin.Unit;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.Utils;
import retrofit2.http.Streaming;

final class BuiltInConverters
extends Converter.Factory {
    private boolean checkForKotlinUnit = true;

    BuiltInConverters() {
    }

    @Override
    @Nullable
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] annotationArray, Annotation[] annotationArray2, Retrofit retrofit) {
        if (RequestBody.class.isAssignableFrom(Utils.getRawType(type))) {
            return RequestBodyConverter.INSTANCE;
        }
        return null;
    }

    @Override
    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type converter, Annotation[] annotationArray, Retrofit retrofit) {
        if (converter == ResponseBody.class) {
            converter = Utils.isAnnotationPresent(annotationArray, Streaming.class) ? StreamingResponseBodyConverter.INSTANCE : BufferingResponseBodyConverter.INSTANCE;
            return converter;
        }
        if (converter == Void.class) {
            return VoidResponseBodyConverter.INSTANCE;
        }
        if (this.checkForKotlinUnit && converter == Unit.class) {
            try {
                converter = UnitResponseBodyConverter.INSTANCE;
                return converter;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.checkForKotlinUnit = false;
            }
        }
        return null;
    }

    static final class BufferingResponseBodyConverter
    implements Converter<ResponseBody, ResponseBody> {
        static final BufferingResponseBodyConverter INSTANCE = new BufferingResponseBodyConverter();

        BufferingResponseBodyConverter() {
        }

        @Override
        public ResponseBody convert(ResponseBody responseBody) throws IOException {
            try {
                ResponseBody responseBody2 = Utils.buffer(responseBody);
                return responseBody2;
            }
            finally {
                responseBody.close();
            }
        }
    }

    static final class RequestBodyConverter
    implements Converter<RequestBody, RequestBody> {
        static final RequestBodyConverter INSTANCE = new RequestBodyConverter();

        RequestBodyConverter() {
        }

        @Override
        public RequestBody convert(RequestBody requestBody) {
            return requestBody;
        }
    }

    static final class StreamingResponseBodyConverter
    implements Converter<ResponseBody, ResponseBody> {
        static final StreamingResponseBodyConverter INSTANCE = new StreamingResponseBodyConverter();

        StreamingResponseBodyConverter() {
        }

        @Override
        public ResponseBody convert(ResponseBody responseBody) {
            return responseBody;
        }
    }

    static final class ToStringConverter
    implements Converter<Object, String> {
        static final ToStringConverter INSTANCE = new ToStringConverter();

        ToStringConverter() {
        }

        @Override
        public String convert(Object object) {
            return object.toString();
        }
    }

    static final class UnitResponseBodyConverter
    implements Converter<ResponseBody, Unit> {
        static final UnitResponseBodyConverter INSTANCE = new UnitResponseBodyConverter();

        UnitResponseBodyConverter() {
        }

        @Override
        public Unit convert(ResponseBody responseBody) {
            responseBody.close();
            return Unit.INSTANCE;
        }
    }

    static final class VoidResponseBodyConverter
    implements Converter<ResponseBody, Void> {
        static final VoidResponseBodyConverter INSTANCE = new VoidResponseBodyConverter();

        VoidResponseBodyConverter() {
        }

        @Override
        public Void convert(ResponseBody responseBody) {
            responseBody.close();
            return null;
        }
    }
}

