/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;
import retrofit2.Retrofit;

final class CompletableFutureCallAdapterFactory
extends CallAdapter.Factory {
    static final CallAdapter.Factory INSTANCE = new CompletableFutureCallAdapterFactory();

    CompletableFutureCallAdapterFactory() {
    }

    @Override
    @Nullable
    public CallAdapter<?, ?> get(Type type, Annotation[] annotationArray, Retrofit retrofit) {
        if (CompletableFutureCallAdapterFactory.getRawType(type) != CompletableFuture.class) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            if (CompletableFutureCallAdapterFactory.getRawType(type = CompletableFutureCallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)type)) != Response.class) {
                return new BodyCallAdapter(type);
            }
            if (type instanceof ParameterizedType) {
                return new ResponseCallAdapter(CompletableFutureCallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)type));
            }
            throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
        }
        throw new IllegalStateException("CompletableFuture return type must be parameterized as CompletableFuture<Foo> or CompletableFuture<? extends Foo>");
    }

    private static final class BodyCallAdapter<R>
    implements CallAdapter<R, CompletableFuture<R>> {
        private final Type responseType;

        BodyCallAdapter(Type type) {
            this.responseType = type;
        }

        @Override
        public CompletableFuture<R> adapt(final Call<R> call) {
            final CompletableFuture completableFuture = new CompletableFuture<R>(){

                @Override
                public boolean cancel(boolean bl) {
                    if (bl) {
                        call.cancel();
                    }
                    return super.cancel(bl);
                }
            };
            call.enqueue(new Callback<R>(){

                @Override
                public void onFailure(Call<R> call, Throwable throwable) {
                    completableFuture.completeExceptionally(throwable);
                }

                @Override
                public void onResponse(Call<R> call, Response<R> response) {
                    if (response.isSuccessful()) {
                        completableFuture.complete(response.body());
                    } else {
                        completableFuture.completeExceptionally(new HttpException(response));
                    }
                }
            });
            return completableFuture;
        }

        @Override
        public Type responseType() {
            return this.responseType;
        }
    }

    private static final class ResponseCallAdapter<R>
    implements CallAdapter<R, CompletableFuture<Response<R>>> {
        private final Type responseType;

        ResponseCallAdapter(Type type) {
            this.responseType = type;
        }

        @Override
        public CompletableFuture<Response<R>> adapt(final Call<R> call) {
            final CompletableFuture completableFuture = new CompletableFuture<Response<R>>(){

                @Override
                public boolean cancel(boolean bl) {
                    if (bl) {
                        call.cancel();
                    }
                    return super.cancel(bl);
                }
            };
            call.enqueue(new Callback<R>(){

                @Override
                public void onFailure(Call<R> call, Throwable throwable) {
                    completableFuture.completeExceptionally(throwable);
                }

                @Override
                public void onResponse(Call<R> call, Response<R> response) {
                    completableFuture.complete(response);
                }
            });
            return completableFuture;
        }

        @Override
        public Type responseType() {
            return this.responseType;
        }
    }
}

