/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import okhttp3.Request;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.DefaultCallAdapterFactory$ExecutorCallbackCall$1$$ExternalSyntheticLambda0;
import retrofit2.DefaultCallAdapterFactory$ExecutorCallbackCall$1$$ExternalSyntheticLambda1;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.SkipCallbackExecutor;
import retrofit2.Utils;

final class DefaultCallAdapterFactory
extends CallAdapter.Factory {
    @Nullable
    private final Executor callbackExecutor;

    DefaultCallAdapterFactory(@Nullable Executor executor) {
        this.callbackExecutor = executor;
    }

    @Override
    @Nullable
    public CallAdapter<?, ?> get(Type object, Annotation[] annotationArray, Retrofit retrofit) {
        final Type type = DefaultCallAdapterFactory.getRawType((Type)object);
        retrofit = null;
        if (type != Call.class) {
            return null;
        }
        if (object instanceof ParameterizedType) {
            type = Utils.getParameterUpperBound(0, (ParameterizedType)object);
            object = Utils.isAnnotationPresent(annotationArray, SkipCallbackExecutor.class) ? retrofit : this.callbackExecutor;
            return new CallAdapter<Object, Call<?>>((Executor)object){
                final /* synthetic */ Executor val$executor;
                {
                    this.val$executor = executor;
                }

                @Override
                public Call<Object> adapt(Call<Object> call) {
                    Executor executor = this.val$executor;
                    if (executor != null) {
                        call = new ExecutorCallbackCall<Object>(executor, call);
                    }
                    return call;
                }

                @Override
                public Type responseType() {
                    return type;
                }
            };
        }
        throw new IllegalArgumentException("Call return type must be parameterized as Call<Foo> or Call<? extends Foo>");
    }

    static final class ExecutorCallbackCall<T>
    implements Call<T> {
        final Executor callbackExecutor;
        final Call<T> delegate;

        ExecutorCallbackCall(Executor executor, Call<T> call) {
            this.callbackExecutor = executor;
            this.delegate = call;
        }

        @Override
        public void cancel() {
            this.delegate.cancel();
        }

        @Override
        public Call<T> clone() {
            return new ExecutorCallbackCall<T>(this.callbackExecutor, this.delegate.clone());
        }

        @Override
        public void enqueue(final Callback<T> callback) {
            Objects.requireNonNull(callback, "callback == null");
            this.delegate.enqueue(new Callback<T>(){

                public /* synthetic */ void lambda$onFailure$1$retrofit2-DefaultCallAdapterFactory$ExecutorCallbackCall$1(Callback callback2, Throwable throwable) {
                    callback2.onFailure(ExecutorCallbackCall.this, throwable);
                }

                public /* synthetic */ void lambda$onResponse$0$retrofit2-DefaultCallAdapterFactory$ExecutorCallbackCall$1(Callback callback2, Response response) {
                    if (ExecutorCallbackCall.this.delegate.isCanceled()) {
                        callback2.onFailure(ExecutorCallbackCall.this, new IOException("Canceled"));
                    } else {
                        callback2.onResponse(ExecutorCallbackCall.this, response);
                    }
                }

                @Override
                public void onFailure(Call<T> call, Throwable throwable) {
                    ExecutorCallbackCall.this.callbackExecutor.execute(new DefaultCallAdapterFactory$ExecutorCallbackCall$1$$ExternalSyntheticLambda0(this, callback, throwable));
                }

                @Override
                public void onResponse(Call<T> call, Response<T> response) {
                    ExecutorCallbackCall.this.callbackExecutor.execute(new DefaultCallAdapterFactory$ExecutorCallbackCall$1$$ExternalSyntheticLambda1(this, callback, response));
                }
            });
        }

        @Override
        public Response<T> execute() throws IOException {
            return this.delegate.execute();
        }

        @Override
        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        @Override
        public boolean isExecuted() {
            return this.delegate.isExecuted();
        }

        @Override
        public Request request() {
            return this.delegate.request();
        }
    }
}

