/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import kotlin.coroutines.Continuation;
import okhttp3.Call;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.KotlinExtensions;
import retrofit2.OkHttpCall;
import retrofit2.RequestFactory;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.ServiceMethod;
import retrofit2.SkipCallbackExecutorImpl;
import retrofit2.Utils;

abstract class HttpServiceMethod<ResponseT, ReturnT>
extends ServiceMethod<ReturnT> {
    private final Call.Factory callFactory;
    private final RequestFactory requestFactory;
    private final Converter<ResponseBody, ResponseT> responseConverter;

    HttpServiceMethod(RequestFactory requestFactory, Call.Factory factory, Converter<ResponseBody, ResponseT> converter) {
        this.requestFactory = requestFactory;
        this.callFactory = factory;
        this.responseConverter = converter;
    }

    private static <ResponseT, ReturnT> CallAdapter<ResponseT, ReturnT> createCallAdapter(Retrofit object, Method method, Type type, Annotation[] annotationArray) {
        try {
            object = ((Retrofit)object).callAdapter(type, annotationArray);
            return object;
        }
        catch (RuntimeException runtimeException) {
            throw Utils.methodError(method, runtimeException, "Unable to create call adapter for %s", type);
        }
    }

    private static <ResponseT> Converter<ResponseBody, ResponseT> createResponseConverter(Retrofit object, Method method, Type type) {
        Annotation[] annotationArray = method.getAnnotations();
        try {
            object = ((Retrofit)object).responseBodyConverter(type, annotationArray);
            return object;
        }
        catch (RuntimeException runtimeException) {
            throw Utils.methodError(method, runtimeException, "Unable to create converter for %s", type);
        }
    }

    static <ResponseT, ReturnT> HttpServiceMethod<ResponseT, ReturnT> parseAnnotations(Retrofit object, Method object2, RequestFactory requestFactory) {
        Type type;
        boolean bl;
        Object object3;
        boolean bl2 = requestFactory.isKotlinSuspendFunction;
        Annotation[] annotationArray = ((AccessibleObject)object2).getAnnotations();
        if (bl2) {
            object3 = ((Method)object2).getGenericParameterTypes();
            if (Utils.getRawType((Type)(object3 = Utils.getParameterLowerBound(0, (ParameterizedType)object3[((Type[])object3).length - 1]))) == Response.class && object3 instanceof ParameterizedType) {
                object3 = Utils.getParameterUpperBound(0, (ParameterizedType)object3);
                bl = true;
            } else {
                bl = false;
            }
            type = new Utils.ParameterizedTypeImpl(null, (Type)((Object)Call.class), new Type[]{object3});
            object3 = SkipCallbackExecutorImpl.ensurePresent(annotationArray);
        } else {
            type = ((Method)object2).getGenericReturnType();
            bl = false;
            object3 = annotationArray;
        }
        object3 = HttpServiceMethod.createCallAdapter((Retrofit)object, (Method)object2, type, (Annotation[])object3);
        type = object3.responseType();
        if (type != okhttp3.Response.class) {
            if (type != Response.class) {
                if (requestFactory.httpMethod.equals("HEAD") && !Void.class.equals((Object)type)) {
                    throw Utils.methodError((Method)object2, "HEAD method must use Void as response type.", new Object[0]);
                }
                object2 = HttpServiceMethod.createResponseConverter((Retrofit)object, (Method)object2, type);
                object = ((Retrofit)object).callFactory;
                if (!bl2) {
                    return new CallAdapted(requestFactory, (Call.Factory)object, object2, object3);
                }
                if (bl) {
                    return new SuspendForResponse(requestFactory, (Call.Factory)object, object2, object3);
                }
                return new SuspendForBody(requestFactory, (Call.Factory)object, object2, object3, false);
            }
            throw Utils.methodError((Method)object2, "Response must include generic type (e.g., Response<String>)", new Object[0]);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("'");
        ((StringBuilder)object).append(Utils.getRawType(type).getName());
        ((StringBuilder)object).append("' is not a valid response body type. Did you mean ResponseBody?");
        throw Utils.methodError((Method)object2, ((StringBuilder)object).toString(), new Object[0]);
    }

    @Nullable
    protected abstract ReturnT adapt(Call<ResponseT> var1, Object[] var2);

    @Override
    @Nullable
    final ReturnT invoke(Object[] objectArray) {
        return this.adapt(new OkHttpCall<ResponseT>(this.requestFactory, objectArray, this.callFactory, this.responseConverter), objectArray);
    }

    static final class CallAdapted<ResponseT, ReturnT>
    extends HttpServiceMethod<ResponseT, ReturnT> {
        private final CallAdapter<ResponseT, ReturnT> callAdapter;

        CallAdapted(RequestFactory requestFactory, Call.Factory factory, Converter<ResponseBody, ResponseT> converter, CallAdapter<ResponseT, ReturnT> callAdapter) {
            super(requestFactory, factory, converter);
            this.callAdapter = callAdapter;
        }

        @Override
        protected ReturnT adapt(Call<ResponseT> call, Object[] objectArray) {
            return this.callAdapter.adapt(call);
        }
    }

    static final class SuspendForBody<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;
        private final boolean isNullable;

        SuspendForBody(RequestFactory requestFactory, Call.Factory factory, Converter<ResponseBody, ResponseT> converter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter, boolean bl) {
            super(requestFactory, factory, converter);
            this.callAdapter = callAdapter;
            this.isNullable = bl;
        }

        @Override
        protected Object adapt(Call<ResponseT> object, Object[] continuation) {
            object = this.callAdapter.adapt((Call<ResponseT>)object);
            continuation = (Continuation)continuation[((Object[])continuation).length - 1];
            try {
                object = this.isNullable ? KotlinExtensions.awaitNullable(object, continuation) : KotlinExtensions.await(object, continuation);
                return object;
            }
            catch (Exception exception) {
                return KotlinExtensions.suspendAndThrow(exception, continuation);
            }
        }
    }

    static final class SuspendForResponse<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;

        SuspendForResponse(RequestFactory requestFactory, Call.Factory factory, Converter<ResponseBody, ResponseT> converter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter) {
            super(requestFactory, factory, converter);
            this.callAdapter = callAdapter;
        }

        @Override
        protected Object adapt(Call<ResponseT> continuation, Object[] object) {
            Call<ResponseT> call = this.callAdapter.adapt((Call<ResponseT>)continuation);
            continuation = (Continuation)object[((Object[])object).length - 1];
            try {
                object = KotlinExtensions.awaitResponse(call, continuation);
                return object;
            }
            catch (Exception exception) {
                return KotlinExtensions.suspendAndThrow(exception, continuation);
            }
        }
    }
}

