/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.RequestFactory;
import retrofit2.Response;
import retrofit2.Utils;

final class OkHttpCall<T>
implements Call<T> {
    private final Object[] args;
    private final Call.Factory callFactory;
    private volatile boolean canceled;
    @Nullable
    private Throwable creationFailure;
    private boolean executed;
    @Nullable
    private okhttp3.Call rawCall;
    private final RequestFactory requestFactory;
    private final Converter<ResponseBody, T> responseConverter;

    OkHttpCall(RequestFactory requestFactory, Object[] objectArray, Call.Factory factory, Converter<ResponseBody, T> converter) {
        this.requestFactory = requestFactory;
        this.args = objectArray;
        this.callFactory = factory;
        this.responseConverter = converter;
    }

    private okhttp3.Call createRawCall() throws IOException {
        okhttp3.Call call = this.callFactory.newCall(this.requestFactory.create(this.args));
        Objects.requireNonNull(call, "Call.Factory returned null.");
        return call;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void cancel() {
        this.canceled = true;
        // MONITORENTER : this
        okhttp3.Call call = this.rawCall;
        // MONITOREXIT : this
        if (call == null) return;
        call.cancel();
    }

    @Override
    public OkHttpCall<T> clone() {
        return new OkHttpCall<T>(this.requestFactory, this.args, this.callFactory, this.responseConverter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void enqueue(Callback<T> object) {
        Objects.requireNonNull(object, "callback == null");
        // MONITORENTER : this
        if (this.executed) {
            object = new IllegalStateException("Already executed.");
            throw object;
        }
        this.executed = true;
        okhttp3.Call call = this.rawCall;
        Throwable throwable = this.creationFailure;
        okhttp3.Call call2 = call;
        Throwable throwable2 = throwable;
        if (call == null) {
            call2 = call;
            throwable2 = throwable;
            if (throwable == null) {
                try {
                    this.rawCall = call2 = this.createRawCall();
                    throwable2 = throwable;
                }
                catch (Throwable throwable3) {
                    Utils.throwIfFatal(throwable3);
                    this.creationFailure = throwable3;
                    call2 = call;
                }
            }
        }
        // MONITOREXIT : this
        if (throwable2 != null) {
            object.onFailure(this, throwable2);
            return;
        }
        if (this.canceled) {
            call2.cancel();
        }
        call2.enqueue(new okhttp3.Callback((Callback)object){
            final /* synthetic */ Callback val$callback;
            {
                this.val$callback = callback;
            }

            private void callFailure(Throwable throwable) {
                try {
                    this.val$callback.onFailure(OkHttpCall.this, throwable);
                }
                catch (Throwable throwable2) {
                    Utils.throwIfFatal(throwable2);
                    throwable2.printStackTrace();
                }
            }

            @Override
            public void onFailure(okhttp3.Call call, IOException iOException) {
                this.callFailure(iOException);
            }

            @Override
            public void onResponse(okhttp3.Call object, okhttp3.Response response) {
                try {
                    object = OkHttpCall.this.parseResponse(response);
                }
                catch (Throwable throwable) {
                    Utils.throwIfFatal(throwable);
                    this.callFailure(throwable);
                    return;
                }
                try {
                    this.val$callback.onResponse(OkHttpCall.this, object);
                }
                catch (Throwable throwable) {
                    Utils.throwIfFatal(throwable);
                    throwable.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Response<T> execute() throws IOException {
        Object object;
        block10: {
            // MONITORENTER : this
            if (this.executed) {
                IllegalStateException illegalStateException = new IllegalStateException("Already executed.");
                throw illegalStateException;
            }
            this.executed = true;
            object = this.creationFailure;
            if (object != null) {
                if (object instanceof IOException) throw (IOException)object;
                if (!(object instanceof RuntimeException)) throw (Error)object;
                throw (RuntimeException)object;
            }
            okhttp3.Call call = this.rawCall;
            object = call;
            if (call == null) {
                void var1_5;
                try {
                    this.rawCall = object = this.createRawCall();
                    break block10;
                }
                catch (Error error) {
                }
                catch (RuntimeException runtimeException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Utils.throwIfFatal((Throwable)var1_5);
                this.creationFailure = var1_5;
                throw var1_5;
            }
        }
        // MONITOREXIT : this
        if (!this.canceled) return this.parseResponse(object.execute());
        object.cancel();
        return this.parseResponse(object.execute());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCanceled() {
        boolean bl = this.canceled;
        boolean bl2 = true;
        if (bl) {
            return true;
        }
        synchronized (this) {
            okhttp3.Call call = this.rawCall;
            if (call == null) return false;
            if (!call.isCanceled()) return false;
            return bl2;
        }
    }

    @Override
    public boolean isExecuted() {
        synchronized (this) {
            boolean bl = this.executed;
            return bl;
        }
    }

    Response<T> parseResponse(okhttp3.Response object) throws IOException {
        Object object2 = ((okhttp3.Response)object).body();
        okhttp3.Response response = ((okhttp3.Response)object).newBuilder().body(new NoContentResponseBody(((ResponseBody)object2).contentType(), ((ResponseBody)object2).contentLength())).build();
        int n = response.code();
        if (n >= 200 && n < 300) {
            if (n != 204 && n != 205) {
                object = new ExceptionCatchingResponseBody((ResponseBody)object2);
                try {
                    object2 = Response.success(this.responseConverter.convert((ResponseBody)object), response);
                    return object2;
                }
                catch (RuntimeException runtimeException) {
                    ((ExceptionCatchingResponseBody)object).throwIfCaught();
                    throw runtimeException;
                }
            }
            ((ResponseBody)object2).close();
            return Response.success(null, response);
        }
        try {
            object = Response.error(Utils.buffer((ResponseBody)object2), response);
            return object;
        }
        finally {
            ((ResponseBody)object2).close();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Request request() {
        synchronized (this) {
            void var1_4;
            Object object = this.rawCall;
            if (object != null) {
                return object.request();
            }
            object = this.creationFailure;
            if (object != null) {
                if (object instanceof IOException) {
                    object = new RuntimeException("Unable to create request.", this.creationFailure);
                    throw object;
                }
                if (!(object instanceof RuntimeException)) throw (Error)object;
                throw (RuntimeException)object;
            }
            try {
                this.rawCall = object = this.createRawCall();
                return object.request();
            }
            catch (IOException iOException) {
                this.creationFailure = iOException;
                object = new RuntimeException("Unable to create request.", iOException);
                throw object;
            }
            catch (Error error) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Utils.throwIfFatal((Throwable)var1_4);
            this.creationFailure = var1_4;
            throw var1_4;
        }
    }

    static final class ExceptionCatchingResponseBody
    extends ResponseBody {
        private final ResponseBody delegate;
        private final BufferedSource delegateSource;
        @Nullable
        IOException thrownException;

        ExceptionCatchingResponseBody(ResponseBody responseBody) {
            this.delegate = responseBody;
            this.delegateSource = Okio.buffer(new ForwardingSource(responseBody.source()){

                @Override
                public long read(Buffer buffer, long l) throws IOException {
                    try {
                        l = super.read(buffer, l);
                        return l;
                    }
                    catch (IOException iOException) {
                        ExceptionCatchingResponseBody.this.thrownException = iOException;
                        throw iOException;
                    }
                }
            });
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public long contentLength() {
            return this.delegate.contentLength();
        }

        @Override
        public MediaType contentType() {
            return this.delegate.contentType();
        }

        @Override
        public BufferedSource source() {
            return this.delegateSource;
        }

        void throwIfCaught() throws IOException {
            IOException iOException = this.thrownException;
            if (iOException == null) {
                return;
            }
            throw iOException;
        }
    }

    static final class NoContentResponseBody
    extends ResponseBody {
        private final long contentLength;
        @Nullable
        private final MediaType contentType;

        NoContentResponseBody(@Nullable MediaType mediaType, long l) {
            this.contentType = mediaType;
            this.contentLength = l;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }
}

