/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.RequestBuilder;
import retrofit2.Utils;

abstract class ParameterHandler<T> {
    ParameterHandler() {
    }

    abstract void apply(RequestBuilder var1, @Nullable T var2) throws IOException;

    final ParameterHandler<Object> array() {
        return new ParameterHandler<Object>(){

            @Override
            void apply(RequestBuilder requestBuilder, @Nullable Object object) throws IOException {
                if (object == null) {
                    return;
                }
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    ParameterHandler.this.apply(requestBuilder, Array.get(object, i));
                }
            }
        };
    }

    final ParameterHandler<Iterable<T>> iterable() {
        return new ParameterHandler<Iterable<T>>(){

            @Override
            void apply(RequestBuilder requestBuilder, @Nullable Iterable<T> object) throws IOException {
                if (object == null) {
                    return;
                }
                object = object.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    ParameterHandler.this.apply(requestBuilder, e);
                }
            }
        };
    }

    static final class Body<T>
    extends ParameterHandler<T> {
        private final Converter<T, RequestBody> converter;
        private final Method method;
        private final int p;

        Body(Method method, int n, Converter<T, RequestBody> converter) {
            this.method = method;
            this.p = n;
            this.converter = converter;
        }

        @Override
        void apply(RequestBuilder object, @Nullable T t) {
            if (t != null) {
                try {
                    RequestBody requestBody = this.converter.convert(t);
                    ((RequestBuilder)object).setBody(requestBody);
                    return;
                }
                catch (IOException iOException) {
                    object = this.method;
                    int n = this.p;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unable to convert ");
                    stringBuilder.append(t);
                    stringBuilder.append(" to RequestBody");
                    throw Utils.parameterError((Method)object, iOException, n, stringBuilder.toString(), new Object[0]);
                }
            }
            throw Utils.parameterError(this.method, this.p, "Body parameter value must not be null.", new Object[0]);
        }
    }

    static final class Field<T>
    extends ParameterHandler<T> {
        private final boolean encoded;
        private final String name;
        private final Converter<T, String> valueConverter;

        Field(String string2, Converter<T, String> converter, boolean bl) {
            Objects.requireNonNull(string2, "name == null");
            String string3 = string2;
            this.name = string2;
            this.valueConverter = converter;
            this.encoded = bl;
        }

        @Override
        void apply(RequestBuilder requestBuilder, @Nullable T object) throws IOException {
            if (object == null) {
                return;
            }
            if ((object = this.valueConverter.convert(object)) == null) {
                return;
            }
            requestBuilder.addFormField(this.name, (String)object, this.encoded);
        }
    }

    static final class FieldMap<T>
    extends ParameterHandler<Map<String, T>> {
        private final boolean encoded;
        private final Method method;
        private final int p;
        private final Converter<T, String> valueConverter;

        FieldMap(Method method, int n, Converter<T, String> converter, boolean bl) {
            this.method = method;
            this.p = n;
            this.valueConverter = converter;
            this.encoded = bl;
        }

        @Override
        void apply(RequestBuilder object, @Nullable Map<String, T> object2) throws IOException {
            if (object2 != null) {
                Object object3 = object2.entrySet().iterator();
                while (object3.hasNext()) {
                    Map.Entry<String, T> entry = object3.next();
                    object2 = entry.getKey();
                    if (object2 != null) {
                        if ((entry = entry.getValue()) != null) {
                            String string2 = this.valueConverter.convert(entry);
                            if (string2 != null) {
                                ((RequestBuilder)object).addFormField((String)object2, string2, this.encoded);
                                continue;
                            }
                            object = this.method;
                            int n = this.p;
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("Field map value '");
                            ((StringBuilder)object3).append(entry);
                            ((StringBuilder)object3).append("' converted to null by ");
                            ((StringBuilder)object3).append(this.valueConverter.getClass().getName());
                            ((StringBuilder)object3).append(" for key '");
                            ((StringBuilder)object3).append((String)object2);
                            ((StringBuilder)object3).append("'.");
                            throw Utils.parameterError((Method)object, n, ((StringBuilder)object3).toString(), new Object[0]);
                        }
                        object = this.method;
                        int n = this.p;
                        entry = new StringBuilder();
                        ((StringBuilder)((Object)entry)).append("Field map contained null value for key '");
                        ((StringBuilder)((Object)entry)).append((String)object2);
                        ((StringBuilder)((Object)entry)).append("'.");
                        throw Utils.parameterError((Method)object, n, ((StringBuilder)((Object)entry)).toString(), new Object[0]);
                    }
                    throw Utils.parameterError(this.method, this.p, "Field map contained null key.", new Object[0]);
                }
                return;
            }
            throw Utils.parameterError(this.method, this.p, "Field map was null.", new Object[0]);
        }
    }

    static final class Header<T>
    extends ParameterHandler<T> {
        private final String name;
        private final Converter<T, String> valueConverter;

        Header(String string2, Converter<T, String> converter) {
            Objects.requireNonNull(string2, "name == null");
            String string3 = string2;
            this.name = string2;
            this.valueConverter = converter;
        }

        @Override
        void apply(RequestBuilder requestBuilder, @Nullable T object) throws IOException {
            if (object == null) {
                return;
            }
            if ((object = this.valueConverter.convert(object)) == null) {
                return;
            }
            requestBuilder.addHeader(this.name, (String)object);
        }
    }

    static final class HeaderMap<T>
    extends ParameterHandler<Map<String, T>> {
        private final Method method;
        private final int p;
        private final Converter<T, String> valueConverter;

        HeaderMap(Method method, int n, Converter<T, String> converter) {
            this.method = method;
            this.p = n;
            this.valueConverter = converter;
        }

        @Override
        void apply(RequestBuilder object, @Nullable Map<String, T> object2) throws IOException {
            if (object2 != null) {
                Object object3 = object2.entrySet().iterator();
                while (object3.hasNext()) {
                    Map.Entry<String, Object> entry = object3.next();
                    object2 = entry.getKey();
                    if (object2 != null) {
                        if ((entry = entry.getValue()) != null) {
                            ((RequestBuilder)object).addHeader((String)object2, this.valueConverter.convert(entry));
                            continue;
                        }
                        object3 = this.method;
                        int n = this.p;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Header map contained null value for key '");
                        ((StringBuilder)object).append((String)object2);
                        ((StringBuilder)object).append("'.");
                        throw Utils.parameterError((Method)object3, n, ((StringBuilder)object).toString(), new Object[0]);
                    }
                    throw Utils.parameterError(this.method, this.p, "Header map contained null key.", new Object[0]);
                }
                return;
            }
            throw Utils.parameterError(this.method, this.p, "Header map was null.", new Object[0]);
        }
    }

    static final class Headers
    extends ParameterHandler<okhttp3.Headers> {
        private final Method method;
        private final int p;

        Headers(Method method, int n) {
            this.method = method;
            this.p = n;
        }

        @Override
        void apply(RequestBuilder requestBuilder, @Nullable okhttp3.Headers headers) {
            if (headers != null) {
                requestBuilder.addHeaders(headers);
                return;
            }
            throw Utils.parameterError(this.method, this.p, "Headers parameter must not be null.", new Object[0]);
        }
    }

    static final class Part<T>
    extends ParameterHandler<T> {
        private final Converter<T, RequestBody> converter;
        private final okhttp3.Headers headers;
        private final Method method;
        private final int p;

        Part(Method method, int n, okhttp3.Headers headers, Converter<T, RequestBody> converter) {
            this.method = method;
            this.p = n;
            this.headers = headers;
            this.converter = converter;
        }

        @Override
        void apply(RequestBuilder object, @Nullable T t) {
            if (t == null) {
                return;
            }
            try {
                RequestBody requestBody = this.converter.convert(t);
                ((RequestBuilder)object).addPart(this.headers, requestBody);
                return;
            }
            catch (IOException iOException) {
                Method method = this.method;
                int n = this.p;
                object = new StringBuilder();
                ((StringBuilder)object).append("Unable to convert ");
                ((StringBuilder)object).append(t);
                ((StringBuilder)object).append(" to RequestBody");
                throw Utils.parameterError(method, n, ((StringBuilder)object).toString(), iOException);
            }
        }
    }

    static final class PartMap<T>
    extends ParameterHandler<Map<String, T>> {
        private final Method method;
        private final int p;
        private final String transferEncoding;
        private final Converter<T, RequestBody> valueConverter;

        PartMap(Method method, int n, Converter<T, RequestBody> converter, String string2) {
            this.method = method;
            this.p = n;
            this.valueConverter = converter;
            this.transferEncoding = string2;
        }

        @Override
        void apply(RequestBuilder object, @Nullable Map<String, T> object2) throws IOException {
            if (object2 != null) {
                Object object3 = object2.entrySet().iterator();
                while (object3.hasNext()) {
                    Map.Entry<String, T> entry = object3.next();
                    object2 = entry.getKey();
                    if (object2 != null) {
                        T t = entry.getValue();
                        if (t != null) {
                            entry = new StringBuilder();
                            ((StringBuilder)((Object)entry)).append("form-data; name=\"");
                            ((StringBuilder)((Object)entry)).append((String)object2);
                            ((StringBuilder)((Object)entry)).append("\"");
                            ((RequestBuilder)object).addPart(okhttp3.Headers.of("Content-Disposition", ((StringBuilder)((Object)entry)).toString(), "Content-Transfer-Encoding", this.transferEncoding), this.valueConverter.convert(t));
                            continue;
                        }
                        object = this.method;
                        int n = this.p;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("Part map contained null value for key '");
                        ((StringBuilder)object3).append((String)object2);
                        ((StringBuilder)object3).append("'.");
                        throw Utils.parameterError((Method)object, n, ((StringBuilder)object3).toString(), new Object[0]);
                    }
                    throw Utils.parameterError(this.method, this.p, "Part map contained null key.", new Object[0]);
                }
                return;
            }
            throw Utils.parameterError(this.method, this.p, "Part map was null.", new Object[0]);
        }
    }

    static final class Path<T>
    extends ParameterHandler<T> {
        private final boolean encoded;
        private final Method method;
        private final String name;
        private final int p;
        private final Converter<T, String> valueConverter;

        Path(Method object, int n, String string2, Converter<T, String> converter, boolean bl) {
            this.method = object;
            this.p = n;
            Objects.requireNonNull(string2, "name == null");
            object = string2;
            this.name = string2;
            this.valueConverter = converter;
            this.encoded = bl;
        }

        @Override
        void apply(RequestBuilder object, @Nullable T object2) throws IOException {
            if (object2 != null) {
                ((RequestBuilder)object).addPathParam(this.name, this.valueConverter.convert(object2), this.encoded);
                return;
            }
            object = this.method;
            int n = this.p;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Path parameter \"");
            ((StringBuilder)object2).append(this.name);
            ((StringBuilder)object2).append("\" value must not be null.");
            throw Utils.parameterError((Method)object, n, ((StringBuilder)object2).toString(), new Object[0]);
        }
    }

    static final class Query<T>
    extends ParameterHandler<T> {
        private final boolean encoded;
        private final String name;
        private final Converter<T, String> valueConverter;

        Query(String string2, Converter<T, String> converter, boolean bl) {
            Objects.requireNonNull(string2, "name == null");
            String string3 = string2;
            this.name = string2;
            this.valueConverter = converter;
            this.encoded = bl;
        }

        @Override
        void apply(RequestBuilder requestBuilder, @Nullable T object) throws IOException {
            if (object == null) {
                return;
            }
            if ((object = this.valueConverter.convert(object)) == null) {
                return;
            }
            requestBuilder.addQueryParam(this.name, (String)object, this.encoded);
        }
    }

    static final class QueryMap<T>
    extends ParameterHandler<Map<String, T>> {
        private final boolean encoded;
        private final Method method;
        private final int p;
        private final Converter<T, String> valueConverter;

        QueryMap(Method method, int n, Converter<T, String> converter, boolean bl) {
            this.method = method;
            this.p = n;
            this.valueConverter = converter;
            this.encoded = bl;
        }

        @Override
        void apply(RequestBuilder object, @Nullable Map<String, T> object2) throws IOException {
            if (object2 != null) {
                Object object3 = object2.entrySet().iterator();
                while (object3.hasNext()) {
                    Map.Entry<String, T> entry = object3.next();
                    object2 = entry.getKey();
                    if (object2 != null) {
                        if ((entry = entry.getValue()) != null) {
                            String string2 = this.valueConverter.convert(entry);
                            if (string2 != null) {
                                ((RequestBuilder)object).addQueryParam((String)object2, string2, this.encoded);
                                continue;
                            }
                            object = this.method;
                            int n = this.p;
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("Query map value '");
                            ((StringBuilder)object3).append(entry);
                            ((StringBuilder)object3).append("' converted to null by ");
                            ((StringBuilder)object3).append(this.valueConverter.getClass().getName());
                            ((StringBuilder)object3).append(" for key '");
                            ((StringBuilder)object3).append((String)object2);
                            ((StringBuilder)object3).append("'.");
                            throw Utils.parameterError((Method)object, n, ((StringBuilder)object3).toString(), new Object[0]);
                        }
                        entry = this.method;
                        int n = this.p;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Query map contained null value for key '");
                        ((StringBuilder)object).append((String)object2);
                        ((StringBuilder)object).append("'.");
                        throw Utils.parameterError((Method)((Object)entry), n, ((StringBuilder)object).toString(), new Object[0]);
                    }
                    throw Utils.parameterError(this.method, this.p, "Query map contained null key.", new Object[0]);
                }
                return;
            }
            throw Utils.parameterError(this.method, this.p, "Query map was null", new Object[0]);
        }
    }

    static final class QueryName<T>
    extends ParameterHandler<T> {
        private final boolean encoded;
        private final Converter<T, String> nameConverter;

        QueryName(Converter<T, String> converter, boolean bl) {
            this.nameConverter = converter;
            this.encoded = bl;
        }

        @Override
        void apply(RequestBuilder requestBuilder, @Nullable T t) throws IOException {
            if (t == null) {
                return;
            }
            requestBuilder.addQueryParam(this.nameConverter.convert(t), null, this.encoded);
        }
    }

    static final class RawPart
    extends ParameterHandler<MultipartBody.Part> {
        static final RawPart INSTANCE = new RawPart();

        private RawPart() {
        }

        @Override
        void apply(RequestBuilder requestBuilder, @Nullable MultipartBody.Part part) {
            if (part != null) {
                requestBuilder.addPart(part);
            }
        }
    }

    static final class RelativeUrl
    extends ParameterHandler<Object> {
        private final Method method;
        private final int p;

        RelativeUrl(Method method, int n) {
            this.method = method;
            this.p = n;
        }

        @Override
        void apply(RequestBuilder requestBuilder, @Nullable Object object) {
            if (object != null) {
                requestBuilder.setRelativeUrl(object);
                return;
            }
            throw Utils.parameterError(this.method, this.p, "@Url parameter is null.", new Object[0]);
        }
    }

    static final class Tag<T>
    extends ParameterHandler<T> {
        final Class<T> cls;

        Tag(Class<T> clazz) {
            this.cls = clazz;
        }

        @Override
        void apply(RequestBuilder requestBuilder, @Nullable T t) {
            requestBuilder.addTag(this.cls, t);
        }
    }
}

