/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import retrofit2.CallAdapter;
import retrofit2.CompletableFutureCallAdapterFactory;
import retrofit2.Converter;
import retrofit2.DefaultCallAdapterFactory;
import retrofit2.OptionalConverterFactory;

class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    private final boolean hasJava8Types;

    Platform(boolean bl) {
        this.hasJava8Types = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT == 0) return new Platform(true);
            return new Android();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Platform(true);
        }
    }

    static Platform get() {
        return PLATFORM;
    }

    List<? extends CallAdapter.Factory> defaultCallAdapterFactories(@Nullable Executor list) {
        list = new DefaultCallAdapterFactory((Executor)((Object)list));
        list = this.hasJava8Types ? Arrays.asList(CompletableFutureCallAdapterFactory.INSTANCE, list) : Collections.singletonList(list);
        return list;
    }

    int defaultCallAdapterFactoriesSize() {
        int n = this.hasJava8Types ? 2 : 1;
        return n;
    }

    @Nullable
    Executor defaultCallbackExecutor() {
        return null;
    }

    List<? extends Converter.Factory> defaultConverterFactories() {
        List<Object> list = this.hasJava8Types ? Collections.singletonList(OptionalConverterFactory.INSTANCE) : Collections.emptyList();
        return list;
    }

    int defaultConverterFactoriesSize() {
        return this.hasJava8Types ? 1 : 0;
    }

    @Nullable
    Object invokeDefaultMethod(Method method, Class<?> clazz, Object object, Object ... objectArray) throws Throwable {
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        constructor.setAccessible(true);
        return ((MethodHandles.Lookup)constructor.newInstance(clazz, -1)).unreflectSpecial(method, clazz).bindTo(object).invokeWithArguments(objectArray);
    }

    boolean isDefaultMethod(Method method) {
        boolean bl = this.hasJava8Types && method.isDefault();
        return bl;
    }

    static final class Android
    extends Platform {
        Android() {
            boolean bl = Build.VERSION.SDK_INT >= 24;
            super(bl);
        }

        @Override
        public Executor defaultCallbackExecutor() {
            return new MainThreadExecutor();
        }

        static class MainThreadExecutor
        implements Executor {
            private final Handler handler = new Handler(Looper.getMainLooper());

            MainThreadExecutor() {
            }

            @Override
            public void execute(Runnable runnable) {
                this.handler.post(runnable);
            }
        }
    }
}

