/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;

final class RequestBuilder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String PATH_SEGMENT_ALWAYS_ENCODE_SET = " \"<>^`{}|\\?#";
    private static final Pattern PATH_TRAVERSAL = Pattern.compile("(.*/)?(\\.|%2e|%2E){1,2}(/.*)?");
    private final HttpUrl baseUrl;
    @Nullable
    private RequestBody body;
    @Nullable
    private MediaType contentType;
    @Nullable
    private FormBody.Builder formBuilder;
    private final boolean hasBody;
    private final Headers.Builder headersBuilder;
    private final String method;
    @Nullable
    private MultipartBody.Builder multipartBuilder;
    @Nullable
    private String relativeUrl;
    private final Request.Builder requestBuilder;
    @Nullable
    private HttpUrl.Builder urlBuilder;

    RequestBuilder(String object, HttpUrl httpUrl, @Nullable String string2, @Nullable Headers headers, @Nullable MediaType mediaType, boolean bl, boolean bl2, boolean bl3) {
        this.method = object;
        this.baseUrl = httpUrl;
        this.relativeUrl = string2;
        this.requestBuilder = new Request.Builder();
        this.contentType = mediaType;
        this.hasBody = bl;
        this.headersBuilder = headers != null ? headers.newBuilder() : new Headers.Builder();
        if (bl2) {
            this.formBuilder = new FormBody.Builder();
        } else if (bl3) {
            this.multipartBuilder = object = new MultipartBody.Builder();
            ((MultipartBody.Builder)object).setType(MultipartBody.FORM);
        }
    }

    private static String canonicalizeForPath(String string2, boolean bl) {
        Object object;
        block1: {
            int n = string2.length();
            int n2 = 0;
            while (true) {
                object = string2;
                if (n2 >= n) break block1;
                int n3 = string2.codePointAt(n2);
                if (n3 < 32 || n3 >= 127 || PATH_SEGMENT_ALWAYS_ENCODE_SET.indexOf(n3) != -1 || !bl && (n3 == 47 || n3 == 37)) break;
                n2 += Character.charCount(n3);
            }
            object = new Buffer();
            ((Buffer)object).writeUtf8(string2, 0, n2);
            RequestBuilder.canonicalizeForPath((Buffer)object, string2, n2, n, bl);
            object = ((Buffer)object).readUtf8();
        }
        return object;
    }

    /*
     * Exception decompiling
     */
    private static void canonicalizeForPath(Buffer var0, String var1_1, int var2_2, int var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void addFormField(String string2, String string3, boolean bl) {
        if (bl) {
            this.formBuilder.addEncoded(string2, string3);
        } else {
            this.formBuilder.add(string2, string3);
        }
    }

    void addHeader(String string2, String string3) {
        if ("Content-Type".equalsIgnoreCase(string2)) {
            try {
                this.contentType = MediaType.get(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Malformed content type: ");
                stringBuilder.append(string3);
                throw new IllegalArgumentException(stringBuilder.toString(), illegalArgumentException);
            }
        } else {
            this.headersBuilder.add(string2, string3);
        }
    }

    void addHeaders(Headers headers) {
        this.headersBuilder.addAll(headers);
    }

    void addPart(Headers headers, RequestBody requestBody) {
        this.multipartBuilder.addPart(headers, requestBody);
    }

    void addPart(MultipartBody.Part part) {
        this.multipartBuilder.addPart(part);
    }

    void addPathParam(String charSequence, String string2, boolean bl) {
        if (this.relativeUrl != null) {
            String string3 = RequestBuilder.canonicalizeForPath(string2, bl);
            String string4 = this.relativeUrl;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            stringBuilder.append((String)charSequence);
            stringBuilder.append("}");
            charSequence = string4.replace(stringBuilder.toString(), string3);
            if (!PATH_TRAVERSAL.matcher(charSequence).matches()) {
                this.relativeUrl = charSequence;
                return;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("@Path parameters shouldn't perform path traversal ('.' or '..'): ");
            ((StringBuilder)charSequence).append(string2);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }
        throw new AssertionError();
    }

    void addQueryParam(String charSequence, @Nullable String string2, boolean bl) {
        Object object = this.relativeUrl;
        if (object != null) {
            this.urlBuilder = object = this.baseUrl.newBuilder((String)object);
            if (object != null) {
                this.relativeUrl = null;
            } else {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Malformed URL. Base: ");
                ((StringBuilder)charSequence).append(this.baseUrl);
                ((StringBuilder)charSequence).append(", Relative: ");
                ((StringBuilder)charSequence).append(this.relativeUrl);
                throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
            }
        }
        if (bl) {
            this.urlBuilder.addEncodedQueryParameter((String)charSequence, string2);
        } else {
            this.urlBuilder.addQueryParameter((String)charSequence, string2);
        }
    }

    <T> void addTag(Class<T> clazz, @Nullable T t) {
        this.requestBuilder.tag(clazz, t);
    }

    Request.Builder get() {
        Object object;
        block14: {
            Object object2;
            HttpUrl httpUrl;
            block13: {
                block12: {
                    object = this.urlBuilder;
                    if (object == null) break block12;
                    httpUrl = ((HttpUrl.Builder)object).build();
                    break block13;
                }
                httpUrl = this.baseUrl.resolve(this.relativeUrl);
                if (httpUrl == null) break block14;
            }
            object = object2 = this.body;
            if (object2 == null) {
                object = this.formBuilder;
                if (object != null) {
                    object = ((FormBody.Builder)object).build();
                } else {
                    object = this.multipartBuilder;
                    if (object != null) {
                        object = ((MultipartBody.Builder)object).build();
                    } else {
                        object = object2;
                        if (this.hasBody) {
                            object = RequestBody.create(null, new byte[0]);
                        }
                    }
                }
            }
            MediaType mediaType = this.contentType;
            object2 = object;
            if (mediaType != null) {
                if (object != null) {
                    object2 = new ContentTypeOverridingRequestBody((RequestBody)object, mediaType);
                } else {
                    this.headersBuilder.add("Content-Type", mediaType.toString());
                    object2 = object;
                }
            }
            return this.requestBuilder.url(httpUrl).headers(this.headersBuilder.build()).method(this.method, (RequestBody)object2);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Malformed URL. Base: ");
        ((StringBuilder)object).append(this.baseUrl);
        ((StringBuilder)object).append(", Relative: ");
        ((StringBuilder)object).append(this.relativeUrl);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    void setBody(RequestBody requestBody) {
        this.body = requestBody;
    }

    void setRelativeUrl(Object object) {
        this.relativeUrl = object.toString();
    }

    private static class ContentTypeOverridingRequestBody
    extends RequestBody {
        private final MediaType contentType;
        private final RequestBody delegate;

        ContentTypeOverridingRequestBody(RequestBody requestBody, MediaType mediaType) {
            this.delegate = requestBody;
            this.contentType = mediaType;
        }

        @Override
        public long contentLength() throws IOException {
            return this.delegate.contentLength();
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public void writeTo(BufferedSink bufferedSink) throws IOException {
            this.delegate.writeTo(bufferedSink);
        }
    }
}

