/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import kotlin.coroutines.Continuation;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import retrofit2.Invocation;
import retrofit2.ParameterHandler;
import retrofit2.RequestBuilder;
import retrofit2.Retrofit;
import retrofit2.Utils;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.Field;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.HeaderMap;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.OPTIONS;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.QueryName;
import retrofit2.http.Tag;
import retrofit2.http.Url;

final class RequestFactory {
    private final HttpUrl baseUrl;
    @Nullable
    private final MediaType contentType;
    private final boolean hasBody;
    @Nullable
    private final okhttp3.Headers headers;
    final String httpMethod;
    private final boolean isFormEncoded;
    final boolean isKotlinSuspendFunction;
    private final boolean isMultipart;
    private final Method method;
    private final ParameterHandler<?>[] parameterHandlers;
    @Nullable
    private final String relativeUrl;

    RequestFactory(Builder builder) {
        this.method = builder.method;
        this.baseUrl = builder.retrofit.baseUrl;
        this.httpMethod = builder.httpMethod;
        this.relativeUrl = builder.relativeUrl;
        this.headers = builder.headers;
        this.contentType = builder.contentType;
        this.hasBody = builder.hasBody;
        this.isFormEncoded = builder.isFormEncoded;
        this.isMultipart = builder.isMultipart;
        this.parameterHandlers = builder.parameterHandlers;
        this.isKotlinSuspendFunction = builder.isKotlinSuspendFunction;
    }

    static RequestFactory parseAnnotations(Retrofit retrofit, Method method) {
        return new Builder(retrofit, method).build();
    }

    Request create(Object[] object) throws IOException {
        int n = ((Object[])object).length;
        ParameterHandler<?>[] parameterHandlerArray = this.parameterHandlers;
        if (n == parameterHandlerArray.length) {
            RequestBuilder requestBuilder = new RequestBuilder(this.httpMethod, this.baseUrl, this.relativeUrl, this.headers, this.contentType, this.hasBody, this.isFormEncoded, this.isMultipart);
            int n2 = n;
            if (this.isKotlinSuspendFunction) {
                n2 = n - 1;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(n2);
            for (n = 0; n < n2; ++n) {
                arrayList.add(object[n]);
                parameterHandlerArray[n].apply(requestBuilder, object[n]);
            }
            return requestBuilder.get().tag(Invocation.class, new Invocation(this.method, arrayList)).build();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Argument count (");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(") doesn't match expected count (");
        ((StringBuilder)object).append(parameterHandlerArray.length);
        ((StringBuilder)object).append(")");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    static final class Builder {
        private static final String PARAM = "[a-zA-Z][a-zA-Z0-9_-]*";
        private static final Pattern PARAM_NAME_REGEX;
        private static final Pattern PARAM_URL_REGEX;
        @Nullable
        MediaType contentType;
        boolean gotBody;
        boolean gotField;
        boolean gotPart;
        boolean gotPath;
        boolean gotQuery;
        boolean gotQueryMap;
        boolean gotQueryName;
        boolean gotUrl;
        boolean hasBody;
        @Nullable
        okhttp3.Headers headers;
        @Nullable
        String httpMethod;
        boolean isFormEncoded;
        boolean isKotlinSuspendFunction;
        boolean isMultipart;
        final Method method;
        final Annotation[] methodAnnotations;
        final Annotation[][] parameterAnnotationsArray;
        @Nullable
        ParameterHandler<?>[] parameterHandlers;
        final Type[] parameterTypes;
        @Nullable
        String relativeUrl;
        @Nullable
        Set<String> relativeUrlParamNames;
        final Retrofit retrofit;

        static {
            PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");
            PARAM_NAME_REGEX = Pattern.compile(PARAM);
        }

        Builder(Retrofit retrofit, Method method) {
            this.retrofit = retrofit;
            this.method = method;
            this.methodAnnotations = method.getAnnotations();
            this.parameterTypes = method.getGenericParameterTypes();
            this.parameterAnnotationsArray = method.getParameterAnnotations();
        }

        private static Class<?> boxIfPrimitive(Class<?> clazz) {
            if (Boolean.TYPE == clazz) {
                return Boolean.class;
            }
            if (Byte.TYPE == clazz) {
                return Byte.class;
            }
            if (Character.TYPE == clazz) {
                return Character.class;
            }
            if (Double.TYPE == clazz) {
                return Double.class;
            }
            if (Float.TYPE == clazz) {
                return Float.class;
            }
            if (Integer.TYPE == clazz) {
                return Integer.class;
            }
            if (Long.TYPE == clazz) {
                return Long.class;
            }
            Class<Object> clazz2 = clazz;
            if (Short.TYPE == clazz) {
                clazz2 = Short.class;
            }
            return clazz2;
        }

        private okhttp3.Headers parseHeaders(String[] stringArray) {
            Headers.Builder builder = new Headers.Builder();
            for (String string2 : stringArray) {
                int n = string2.indexOf(58);
                if (n != -1 && n != 0 && n != string2.length() - 1) {
                    String string3 = string2.substring(0, n);
                    string2 = string2.substring(n + 1).trim();
                    if ("Content-Type".equalsIgnoreCase(string3)) {
                        try {
                            this.contentType = MediaType.get(string2);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw Utils.methodError(this.method, illegalArgumentException, "Malformed content type: %s", string2);
                        }
                    }
                    builder.add(string3, string2);
                    continue;
                }
                throw Utils.methodError(this.method, "@Headers value must be in the form \"Name: Value\". Found: \"%s\"", string2);
            }
            return builder.build();
        }

        private void parseHttpMethodAndPath(String string2, String string3, boolean bl) {
            String string4 = this.httpMethod;
            if (string4 == null) {
                this.httpMethod = string2;
                this.hasBody = bl;
                if (string3.isEmpty()) {
                    return;
                }
                int n = string3.indexOf(63);
                if (n != -1 && n < string3.length() - 1 && PARAM_URL_REGEX.matcher(string2 = string3.substring(n + 1)).find()) {
                    throw Utils.methodError(this.method, "URL query string \"%s\" must not have replace block. For dynamic query parameters use @Query.", string2);
                }
                this.relativeUrl = string3;
                this.relativeUrlParamNames = Builder.parsePathParameters(string3);
                return;
            }
            throw Utils.methodError(this.method, "Only one HTTP method is allowed. Found: %s and %s.", string4, string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void parseMethodAnnotation(Annotation object) {
            if (object instanceof DELETE) {
                this.parseHttpMethodAndPath("DELETE", ((DELETE)object).value(), false);
                return;
            } else if (object instanceof GET) {
                this.parseHttpMethodAndPath("GET", ((GET)object).value(), false);
                return;
            } else if (object instanceof HEAD) {
                this.parseHttpMethodAndPath("HEAD", ((HEAD)object).value(), false);
                return;
            } else if (object instanceof PATCH) {
                this.parseHttpMethodAndPath("PATCH", ((PATCH)object).value(), true);
                return;
            } else if (object instanceof POST) {
                this.parseHttpMethodAndPath("POST", ((POST)object).value(), true);
                return;
            } else if (object instanceof PUT) {
                this.parseHttpMethodAndPath("PUT", ((PUT)object).value(), true);
                return;
            } else if (object instanceof OPTIONS) {
                this.parseHttpMethodAndPath("OPTIONS", ((OPTIONS)object).value(), false);
                return;
            } else if (object instanceof HTTP) {
                object = (HTTP)object;
                this.parseHttpMethodAndPath(object.method(), object.path(), object.hasBody());
                return;
            } else if (object instanceof Headers) {
                if (((Object)(object = ((Headers)object).value())).length == 0) throw Utils.methodError(this.method, "@Headers annotation is empty.", new Object[0]);
                this.headers = this.parseHeaders((String[])object);
                return;
            } else if (object instanceof Multipart) {
                if (this.isFormEncoded) throw Utils.methodError(this.method, "Only one encoding annotation is allowed.", new Object[0]);
                this.isMultipart = true;
                return;
            } else {
                if (!(object instanceof FormUrlEncoded)) return;
                if (this.isMultipart) throw Utils.methodError(this.method, "Only one encoding annotation is allowed.", new Object[0]);
                this.isFormEncoded = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private ParameterHandler<?> parseParameter(int n, Type type, @Nullable Annotation[] annotationArray, boolean bl) {
            ParameterHandler<?> parameterHandler;
            if (annotationArray == null) {
                parameterHandler = null;
            } else {
                int n2 = annotationArray.length;
                ParameterHandler<?> parameterHandler2 = null;
                int n3 = 0;
                while (true) {
                    parameterHandler = parameterHandler2;
                    if (n3 >= n2) break;
                    parameterHandler = this.parseParameterAnnotation(n, type, annotationArray, annotationArray[n3]);
                    if (parameterHandler != null) {
                        if (parameterHandler2 != null) throw Utils.parameterError(this.method, n, "Multiple Retrofit annotations found, only one allowed.", new Object[0]);
                        parameterHandler2 = parameterHandler;
                    }
                    ++n3;
                }
            }
            if (parameterHandler != null) return parameterHandler;
            if (!bl) throw Utils.parameterError(this.method, n, "No Retrofit annotation found.", new Object[0]);
            try {
                if (Utils.getRawType(type) != Continuation.class) throw Utils.parameterError(this.method, n, "No Retrofit annotation found.", new Object[0]);
                this.isKotlinSuspendFunction = true;
                return null;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw Utils.parameterError(this.method, n, "No Retrofit annotation found.", new Object[0]);
            }
        }

        @Nullable
        private ParameterHandler<?> parseParameterAnnotation(int n, Type object, Annotation[] object2, Annotation object3) {
            if (object3 instanceof Url) {
                this.validateResolvableType(n, (Type)object);
                if (!this.gotUrl) {
                    if (!this.gotPath) {
                        if (!this.gotQuery) {
                            if (!this.gotQueryName) {
                                if (!this.gotQueryMap) {
                                    if (this.relativeUrl == null) {
                                        this.gotUrl = true;
                                        if (!(object == HttpUrl.class || object == String.class || object == URI.class || object instanceof Class && "android.net.Uri".equals(((Class)object).getName()))) {
                                            throw Utils.parameterError(this.method, n, "@Url must be okhttp3.HttpUrl, String, java.net.URI, or android.net.Uri type.", new Object[0]);
                                        }
                                        return new ParameterHandler.RelativeUrl(this.method, n);
                                    }
                                    throw Utils.parameterError(this.method, n, "@Url cannot be used with @%s URL", this.httpMethod);
                                }
                                throw Utils.parameterError(this.method, n, "A @Url parameter must not come after a @QueryMap.", new Object[0]);
                            }
                            throw Utils.parameterError(this.method, n, "A @Url parameter must not come after a @QueryName.", new Object[0]);
                        }
                        throw Utils.parameterError(this.method, n, "A @Url parameter must not come after a @Query.", new Object[0]);
                    }
                    throw Utils.parameterError(this.method, n, "@Path parameters may not be used with @Url.", new Object[0]);
                }
                throw Utils.parameterError(this.method, n, "Multiple @Url method annotations found.", new Object[0]);
            }
            if (object3 instanceof Path) {
                this.validateResolvableType(n, (Type)object);
                if (!this.gotQuery) {
                    if (!this.gotQueryName) {
                        if (!this.gotQueryMap) {
                            if (!this.gotUrl) {
                                if (this.relativeUrl != null) {
                                    this.gotPath = true;
                                    object3 = (Path)object3;
                                    String string2 = object3.value();
                                    this.validatePathName(n, string2);
                                    object = this.retrofit.stringConverter((Type)object, (Annotation[])object2);
                                    return new ParameterHandler.Path(this.method, n, string2, object, object3.encoded());
                                }
                                throw Utils.parameterError(this.method, n, "@Path can only be used with relative url on @%s", this.httpMethod);
                            }
                            throw Utils.parameterError(this.method, n, "@Path parameters may not be used with @Url.", new Object[0]);
                        }
                        throw Utils.parameterError(this.method, n, "A @Path parameter must not come after a @QueryMap.", new Object[0]);
                    }
                    throw Utils.parameterError(this.method, n, "A @Path parameter must not come after a @QueryName.", new Object[0]);
                }
                throw Utils.parameterError(this.method, n, "A @Path parameter must not come after a @Query.", new Object[0]);
            }
            if (object3 instanceof Query) {
                this.validateResolvableType(n, (Type)object);
                Object object4 = (Query)object3;
                object3 = object4.value();
                boolean bl = object4.encoded();
                object4 = Utils.getRawType((Type)object);
                this.gotQuery = true;
                if (Iterable.class.isAssignableFrom((Class<?>)object4)) {
                    if (object instanceof ParameterizedType) {
                        object = Utils.getParameterUpperBound(0, (ParameterizedType)object);
                        return new ParameterHandler.Query((String)object3, this.retrofit.stringConverter((Type)object, (Annotation[])object2), bl).iterable();
                    }
                    object = this.method;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(((Class)object4).getSimpleName());
                    ((StringBuilder)object2).append(" must include generic type (e.g., ");
                    ((StringBuilder)object2).append(((Class)object4).getSimpleName());
                    ((StringBuilder)object2).append("<String>)");
                    throw Utils.parameterError(object, n, ((StringBuilder)object2).toString(), new Object[0]);
                }
                if (((Class)object4).isArray()) {
                    object = Builder.boxIfPrimitive(((Class)object4).getComponentType());
                    return new ParameterHandler.Query((String)object3, this.retrofit.stringConverter((Type)object, (Annotation[])object2), bl).array();
                }
                return new ParameterHandler.Query((String)object3, this.retrofit.stringConverter((Type)object, (Annotation[])object2), bl);
            }
            if (object3 instanceof QueryName) {
                this.validateResolvableType(n, (Type)object);
                boolean bl = ((QueryName)object3).encoded();
                object3 = Utils.getRawType((Type)object);
                this.gotQueryName = true;
                if (Iterable.class.isAssignableFrom((Class<?>)object3)) {
                    if (object instanceof ParameterizedType) {
                        object = Utils.getParameterUpperBound(0, (ParameterizedType)object);
                        return new ParameterHandler.QueryName(this.retrofit.stringConverter((Type)object, (Annotation[])object2), bl).iterable();
                    }
                    object = this.method;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(((Class)object3).getSimpleName());
                    ((StringBuilder)object2).append(" must include generic type (e.g., ");
                    ((StringBuilder)object2).append(((Class)object3).getSimpleName());
                    ((StringBuilder)object2).append("<String>)");
                    throw Utils.parameterError(object, n, ((StringBuilder)object2).toString(), new Object[0]);
                }
                if (((Class)object3).isArray()) {
                    object = Builder.boxIfPrimitive(((Class)object3).getComponentType());
                    return new ParameterHandler.QueryName(this.retrofit.stringConverter((Type)object, (Annotation[])object2), bl).array();
                }
                return new ParameterHandler.QueryName(this.retrofit.stringConverter((Type)object, (Annotation[])object2), bl);
            }
            if (object3 instanceof QueryMap) {
                this.validateResolvableType(n, (Type)object);
                Type type = Utils.getRawType((Type)object);
                this.gotQueryMap = true;
                if (Map.class.isAssignableFrom((Class<?>)type)) {
                    if ((object = Utils.getSupertype((Type)object, type, Map.class)) instanceof ParameterizedType) {
                        type = (ParameterizedType)object;
                        if (String.class == (object = Utils.getParameterUpperBound(0, type))) {
                            object = Utils.getParameterUpperBound(1, type);
                            object = this.retrofit.stringConverter((Type)object, (Annotation[])object2);
                            return new ParameterHandler.QueryMap(this.method, n, object, ((QueryMap)object3).encoded());
                        }
                        object2 = this.method;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("@QueryMap keys must be of type String: ");
                        ((StringBuilder)object3).append(object);
                        throw Utils.parameterError((Method)object2, n, ((StringBuilder)object3).toString(), new Object[0]);
                    }
                    throw Utils.parameterError(this.method, n, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                throw Utils.parameterError(this.method, n, "@QueryMap parameter type must be Map.", new Object[0]);
            }
            if (object3 instanceof Header) {
                this.validateResolvableType(n, (Type)object);
                String string3 = ((Header)object3).value();
                object3 = Utils.getRawType((Type)object);
                if (Iterable.class.isAssignableFrom((Class<?>)object3)) {
                    if (object instanceof ParameterizedType) {
                        object = Utils.getParameterUpperBound(0, (ParameterizedType)object);
                        return new ParameterHandler.Header(string3, this.retrofit.stringConverter((Type)object, (Annotation[])object2)).iterable();
                    }
                    object2 = this.method;
                    object = new StringBuilder();
                    ((StringBuilder)object).append(((Class)object3).getSimpleName());
                    ((StringBuilder)object).append(" must include generic type (e.g., ");
                    ((StringBuilder)object).append(((Class)object3).getSimpleName());
                    ((StringBuilder)object).append("<String>)");
                    throw Utils.parameterError((Method)object2, n, ((StringBuilder)object).toString(), new Object[0]);
                }
                if (((Class)object3).isArray()) {
                    object = Builder.boxIfPrimitive(((Class)object3).getComponentType());
                    return new ParameterHandler.Header(string3, this.retrofit.stringConverter((Type)object, (Annotation[])object2)).array();
                }
                return new ParameterHandler.Header(string3, this.retrofit.stringConverter((Type)object, (Annotation[])object2));
            }
            if (object3 instanceof HeaderMap) {
                if (object == okhttp3.Headers.class) {
                    return new ParameterHandler.Headers(this.method, n);
                }
                this.validateResolvableType(n, (Type)object);
                object3 = Utils.getRawType((Type)object);
                if (Map.class.isAssignableFrom((Class<?>)object3)) {
                    if ((object = Utils.getSupertype(object, object3, Map.class)) instanceof ParameterizedType) {
                        object3 = (ParameterizedType)object;
                        if (String.class == (object = Utils.getParameterUpperBound(0, (ParameterizedType)object3))) {
                            object = Utils.getParameterUpperBound(1, (ParameterizedType)object3);
                            object = this.retrofit.stringConverter((Type)object, (Annotation[])object2);
                            return new ParameterHandler.HeaderMap(this.method, n, object);
                        }
                        object3 = this.method;
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("@HeaderMap keys must be of type String: ");
                        ((StringBuilder)object2).append(object);
                        throw Utils.parameterError((Method)object3, n, ((StringBuilder)object2).toString(), new Object[0]);
                    }
                    throw Utils.parameterError(this.method, n, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                throw Utils.parameterError(this.method, n, "@HeaderMap parameter type must be Map.", new Object[0]);
            }
            if (object3 instanceof Field) {
                this.validateResolvableType(n, (Type)object);
                if (this.isFormEncoded) {
                    Class<?> clazz = (Field)object3;
                    object3 = clazz.value();
                    boolean bl = clazz.encoded();
                    this.gotField = true;
                    clazz = Utils.getRawType((Type)object);
                    if (Iterable.class.isAssignableFrom(clazz)) {
                        if (object instanceof ParameterizedType) {
                            object = Utils.getParameterUpperBound(0, (ParameterizedType)object);
                            return new ParameterHandler.Field((String)object3, this.retrofit.stringConverter((Type)object, (Annotation[])object2), bl).iterable();
                        }
                        object2 = this.method;
                        object = new StringBuilder();
                        ((StringBuilder)object).append(clazz.getSimpleName());
                        ((StringBuilder)object).append(" must include generic type (e.g., ");
                        ((StringBuilder)object).append(clazz.getSimpleName());
                        ((StringBuilder)object).append("<String>)");
                        throw Utils.parameterError((Method)object2, n, ((StringBuilder)object).toString(), new Object[0]);
                    }
                    if (clazz.isArray()) {
                        object = Builder.boxIfPrimitive(clazz.getComponentType());
                        return new ParameterHandler.Field((String)object3, this.retrofit.stringConverter((Type)object, (Annotation[])object2), bl).array();
                    }
                    return new ParameterHandler.Field((String)object3, this.retrofit.stringConverter((Type)object, (Annotation[])object2), bl);
                }
                throw Utils.parameterError(this.method, n, "@Field parameters can only be used with form encoding.", new Object[0]);
            }
            if (object3 instanceof FieldMap) {
                this.validateResolvableType(n, (Type)object);
                if (this.isFormEncoded) {
                    Type type = Utils.getRawType((Type)object);
                    if (Map.class.isAssignableFrom((Class<?>)type)) {
                        if ((object = Utils.getSupertype((Type)object, type, Map.class)) instanceof ParameterizedType) {
                            type = (ParameterizedType)object;
                            if (String.class == (object = Utils.getParameterUpperBound(0, type))) {
                                object = Utils.getParameterUpperBound(1, type);
                                object = this.retrofit.stringConverter((Type)object, (Annotation[])object2);
                                this.gotField = true;
                                return new ParameterHandler.FieldMap(this.method, n, object, ((FieldMap)object3).encoded());
                            }
                            object2 = this.method;
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("@FieldMap keys must be of type String: ");
                            ((StringBuilder)object3).append(object);
                            throw Utils.parameterError((Method)object2, n, ((StringBuilder)object3).toString(), new Object[0]);
                        }
                        throw Utils.parameterError(this.method, n, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                    }
                    throw Utils.parameterError(this.method, n, "@FieldMap parameter type must be Map.", new Object[0]);
                }
                throw Utils.parameterError(this.method, n, "@FieldMap parameters can only be used with form encoding.", new Object[0]);
            }
            if (object3 instanceof Part) {
                this.validateResolvableType(n, (Type)object);
                if (this.isMultipart) {
                    Part part = (Part)object3;
                    this.gotPart = true;
                    Object object5 = part.value();
                    object3 = Utils.getRawType(object);
                    if (((String)object5).isEmpty()) {
                        if (Iterable.class.isAssignableFrom((Class<?>)object3)) {
                            if (object instanceof ParameterizedType) {
                                if (MultipartBody.Part.class.isAssignableFrom(Utils.getRawType(Utils.getParameterUpperBound(0, (ParameterizedType)object)))) {
                                    return ParameterHandler.RawPart.INSTANCE.iterable();
                                }
                                throw Utils.parameterError(this.method, n, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                            }
                            object2 = this.method;
                            object = new StringBuilder();
                            ((StringBuilder)object).append(((Class)object3).getSimpleName());
                            ((StringBuilder)object).append(" must include generic type (e.g., ");
                            ((StringBuilder)object).append(((Class)object3).getSimpleName());
                            ((StringBuilder)object).append("<String>)");
                            throw Utils.parameterError((Method)object2, n, ((StringBuilder)object).toString(), new Object[0]);
                        }
                        if (((Class)object3).isArray()) {
                            if (MultipartBody.Part.class.isAssignableFrom(((Class)object3).getComponentType())) {
                                return ParameterHandler.RawPart.INSTANCE.array();
                            }
                            throw Utils.parameterError(this.method, n, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                        }
                        if (MultipartBody.Part.class.isAssignableFrom((Class<?>)object3)) {
                            return ParameterHandler.RawPart.INSTANCE;
                        }
                        throw Utils.parameterError(this.method, n, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("form-data; name=\"");
                    stringBuilder.append((String)object5);
                    stringBuilder.append("\"");
                    object5 = okhttp3.Headers.of("Content-Disposition", stringBuilder.toString(), "Content-Transfer-Encoding", part.encoding());
                    if (Iterable.class.isAssignableFrom((Class<?>)object3)) {
                        if (object instanceof ParameterizedType) {
                            if (!MultipartBody.Part.class.isAssignableFrom(Utils.getRawType((Type)(object = Utils.getParameterUpperBound(0, (ParameterizedType)object))))) {
                                object = this.retrofit.requestBodyConverter((Type)object, (Annotation[])object2, this.methodAnnotations);
                                return new ParameterHandler.Part(this.method, n, (okhttp3.Headers)object5, object).iterable();
                            }
                            throw Utils.parameterError(this.method, n, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                        }
                        object2 = this.method;
                        object = new StringBuilder();
                        ((StringBuilder)object).append(((Class)object3).getSimpleName());
                        ((StringBuilder)object).append(" must include generic type (e.g., ");
                        ((StringBuilder)object).append(((Class)object3).getSimpleName());
                        ((StringBuilder)object).append("<String>)");
                        throw Utils.parameterError((Method)object2, n, ((StringBuilder)object).toString(), new Object[0]);
                    }
                    if (((Class)object3).isArray()) {
                        object = Builder.boxIfPrimitive(((Class)object3).getComponentType());
                        if (!MultipartBody.Part.class.isAssignableFrom((Class<?>)object)) {
                            object = this.retrofit.requestBodyConverter((Type)object, (Annotation[])object2, this.methodAnnotations);
                            return new ParameterHandler.Part(this.method, n, (okhttp3.Headers)object5, object).array();
                        }
                        throw Utils.parameterError(this.method, n, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                    }
                    if (!MultipartBody.Part.class.isAssignableFrom((Class<?>)object3)) {
                        object = this.retrofit.requestBodyConverter((Type)object, (Annotation[])object2, this.methodAnnotations);
                        return new ParameterHandler.Part(this.method, n, (okhttp3.Headers)object5, object);
                    }
                    throw Utils.parameterError(this.method, n, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                }
                throw Utils.parameterError(this.method, n, "@Part parameters can only be used with multipart encoding.", new Object[0]);
            }
            if (object3 instanceof PartMap) {
                this.validateResolvableType(n, (Type)object);
                if (this.isMultipart) {
                    this.gotPart = true;
                    Type type = Utils.getRawType((Type)object);
                    if (Map.class.isAssignableFrom((Class<?>)type)) {
                        if ((object = Utils.getSupertype(object, type, Map.class)) instanceof ParameterizedType) {
                            type = (ParameterizedType)object;
                            if (String.class == (object = Utils.getParameterUpperBound(0, type))) {
                                object = Utils.getParameterUpperBound(1, type);
                                if (!MultipartBody.Part.class.isAssignableFrom(Utils.getRawType((Type)object))) {
                                    object = this.retrofit.requestBodyConverter((Type)object, (Annotation[])object2, this.methodAnnotations);
                                    object2 = (PartMap)object3;
                                    return new ParameterHandler.PartMap(this.method, n, object, object2.encoding());
                                }
                                throw Utils.parameterError(this.method, n, "@PartMap values cannot be MultipartBody.Part. Use @Part List<Part> or a different value type instead.", new Object[0]);
                            }
                            object3 = this.method;
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("@PartMap keys must be of type String: ");
                            ((StringBuilder)object2).append(object);
                            throw Utils.parameterError((Method)object3, n, ((StringBuilder)object2).toString(), new Object[0]);
                        }
                        throw Utils.parameterError(this.method, n, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                    }
                    throw Utils.parameterError(this.method, n, "@PartMap parameter type must be Map.", new Object[0]);
                }
                throw Utils.parameterError(this.method, n, "@PartMap parameters can only be used with multipart encoding.", new Object[0]);
            }
            if (object3 instanceof Body) {
                this.validateResolvableType(n, (Type)object);
                if (!this.isFormEncoded && !this.isMultipart) {
                    if (!this.gotBody) {
                        try {
                            object2 = this.retrofit.requestBodyConverter((Type)object, (Annotation[])object2, this.methodAnnotations);
                            this.gotBody = true;
                        }
                        catch (RuntimeException runtimeException) {
                            throw Utils.parameterError(this.method, runtimeException, n, "Unable to create @Body converter for %s", object);
                        }
                        return new ParameterHandler.Body(this.method, n, object2);
                    }
                    throw Utils.parameterError(this.method, n, "Multiple @Body method annotations found.", new Object[0]);
                }
                throw Utils.parameterError(this.method, n, "@Body parameters cannot be used with form or multi-part encoding.", new Object[0]);
            }
            if (object3 instanceof Tag) {
                this.validateResolvableType(n, (Type)object);
                object = Utils.getRawType((Type)object);
                for (int i = n - 1; i >= 0; --i) {
                    object2 = this.parameterHandlers[i];
                    if (!(object2 instanceof ParameterHandler.Tag) || !((ParameterHandler.Tag)object2).cls.equals(object)) continue;
                    object3 = this.method;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("@Tag type ");
                    ((StringBuilder)object2).append(((Class)object).getName());
                    ((StringBuilder)object2).append(" is duplicate of parameter #");
                    ((StringBuilder)object2).append(i + 1);
                    ((StringBuilder)object2).append(" and would always overwrite its value.");
                    throw Utils.parameterError((Method)object3, n, ((StringBuilder)object2).toString(), new Object[0]);
                }
                return new ParameterHandler.Tag((Class<?>)object);
            }
            return null;
        }

        static Set<String> parsePathParameters(String object) {
            Matcher matcher = PARAM_URL_REGEX.matcher((CharSequence)object);
            object = new LinkedHashSet();
            while (matcher.find()) {
                object.add(matcher.group(1));
            }
            return object;
        }

        private void validatePathName(int n, String string2) {
            if (PARAM_NAME_REGEX.matcher(string2).matches()) {
                if (this.relativeUrlParamNames.contains(string2)) {
                    return;
                }
                throw Utils.parameterError(this.method, n, "URL \"%s\" does not contain \"{%s}\".", this.relativeUrl, string2);
            }
            throw Utils.parameterError(this.method, n, "@Path parameter name must match %s. Found: %s", PARAM_URL_REGEX.pattern(), string2);
        }

        private void validateResolvableType(int n, Type type) {
            if (!Utils.hasUnresolvableType(type)) {
                return;
            }
            throw Utils.parameterError(this.method, n, "Parameter type must not include a type variable or wildcard: %s", type);
        }

        RequestFactory build() {
            int n;
            Object object = this.methodAnnotations;
            int n2 = ((Annotation[])object).length;
            for (n = 0; n < n2; ++n) {
                this.parseMethodAnnotation(object[n]);
            }
            if (this.httpMethod != null) {
                boolean bl;
                if (!this.hasBody) {
                    if (!this.isMultipart) {
                        if (this.isFormEncoded) {
                            throw Utils.methodError(this.method, "FormUrlEncoded can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
                        }
                    } else {
                        throw Utils.methodError(this.method, "Multipart can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
                    }
                }
                n2 = this.parameterAnnotationsArray.length;
                this.parameterHandlers = new ParameterHandler[n2];
                n = 0;
                while (true) {
                    bl = true;
                    if (n >= n2) break;
                    ParameterHandler<?>[] parameterHandlerArray = this.parameterHandlers;
                    object = this.parameterTypes[n];
                    Annotation[] annotationArray = this.parameterAnnotationsArray[n];
                    if (n != n2 - 1) {
                        bl = false;
                    }
                    parameterHandlerArray[n] = this.parseParameter(n, (Type)object, annotationArray, bl);
                    ++n;
                }
                if (this.relativeUrl == null && !this.gotUrl) {
                    throw Utils.methodError(this.method, "Missing either @%s URL or @Url parameter.", this.httpMethod);
                }
                bl = this.isFormEncoded;
                if (!bl && !this.isMultipart && !this.hasBody && this.gotBody) {
                    throw Utils.methodError(this.method, "Non-body HTTP method cannot contain @Body.", new Object[0]);
                }
                if (bl && !this.gotField) {
                    throw Utils.methodError(this.method, "Form-encoded method must contain at least one @Field.", new Object[0]);
                }
                if (this.isMultipart && !this.gotPart) {
                    throw Utils.methodError(this.method, "Multipart method must contain at least one @Part.", new Object[0]);
                }
                return new RequestFactory(this);
            }
            throw Utils.methodError(this.method, "HTTP method annotation is required (e.g., @GET, @POST, etc.).", new Object[0]);
        }
    }
}

