/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.BuiltInConverters;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Platform;
import retrofit2.ServiceMethod;

public final class Retrofit {
    final HttpUrl baseUrl;
    final List<CallAdapter.Factory> callAdapterFactories;
    final Call.Factory callFactory;
    @Nullable
    final Executor callbackExecutor;
    final List<Converter.Factory> converterFactories;
    private final Map<Method, ServiceMethod<?>> serviceMethodCache = new ConcurrentHashMap();
    final boolean validateEagerly;

    Retrofit(Call.Factory factory, HttpUrl httpUrl, List<Converter.Factory> list, List<CallAdapter.Factory> list2, @Nullable Executor executor, boolean bl) {
        this.callFactory = factory;
        this.baseUrl = httpUrl;
        this.converterFactories = list;
        this.callAdapterFactories = list2;
        this.callbackExecutor = executor;
        this.validateEagerly = bl;
    }

    private void validateServiceInterface(Class<?> object4) {
        if (((Class)object4).isInterface()) {
            Object object;
            Object object2 = new ArrayDeque(1);
            object2.add(object4);
            while (!object2.isEmpty()) {
                object = (Class)object2.removeFirst();
                if (((Class)object).getTypeParameters().length != 0) {
                    object2 = new StringBuilder("Type parameters are unsupported on ");
                    ((StringBuilder)object2).append(((Class)object).getName());
                    if (object != object4) {
                        ((StringBuilder)object2).append(" which is an interface of ");
                        ((StringBuilder)object2).append(((Class)object4).getName());
                    }
                    throw new IllegalArgumentException(((StringBuilder)object2).toString());
                }
                Collections.addAll(object2, ((Class)object).getInterfaces());
            }
            if (this.validateEagerly) {
                object = Platform.get();
                for (Method method : ((Class)object4).getDeclaredMethods()) {
                    if (((Platform)object).isDefaultMethod(method) || Modifier.isStatic(method.getModifiers())) continue;
                    this.loadServiceMethod(method);
                }
            }
            return;
        }
        throw new IllegalArgumentException("API declarations must be interfaces.");
    }

    public HttpUrl baseUrl() {
        return this.baseUrl;
    }

    public CallAdapter<?, ?> callAdapter(Type type, Annotation[] annotationArray) {
        return this.nextCallAdapter(null, type, annotationArray);
    }

    public List<CallAdapter.Factory> callAdapterFactories() {
        return this.callAdapterFactories;
    }

    public Call.Factory callFactory() {
        return this.callFactory;
    }

    @Nullable
    public Executor callbackExecutor() {
        return this.callbackExecutor;
    }

    public List<Converter.Factory> converterFactories() {
        return this.converterFactories;
    }

    public <T> T create(final Class<T> clazz) {
        this.validateServiceInterface(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        InvocationHandler invocationHandler = new InvocationHandler(){
            private final Object[] emptyArgs;
            private final Platform platform = Platform.get();
            {
                this.emptyArgs = new Object[0];
            }

            @Override
            @Nullable
            public Object invoke(Object serviceMethod, Method method, @Nullable Object[] objectArray) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, objectArray);
                }
                if (this.platform.isDefaultMethod(method)) {
                    return this.platform.invokeDefaultMethod(method, clazz, serviceMethod, objectArray);
                }
                serviceMethod = Retrofit.this.loadServiceMethod(method);
                if (objectArray == null) {
                    objectArray = this.emptyArgs;
                }
                return serviceMethod.invoke(objectArray);
            }
        };
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{clazz}, invocationHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ServiceMethod<?> loadServiceMethod(Method method) {
        ServiceMethod<Object> serviceMethod = this.serviceMethodCache.get(method);
        if (serviceMethod != null) {
            return serviceMethod;
        }
        Map<Method, ServiceMethod<?>> map = this.serviceMethodCache;
        synchronized (map) {
            ServiceMethod<?> serviceMethod2;
            serviceMethod = serviceMethod2 = this.serviceMethodCache.get(method);
            if (serviceMethod2 == null) {
                serviceMethod = ServiceMethod.parseAnnotations(this, method);
                this.serviceMethodCache.put(method, serviceMethod);
            }
            return serviceMethod;
        }
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public CallAdapter<?, ?> nextCallAdapter(@Nullable CallAdapter.Factory factory, Type type, Annotation[] object) {
        int n;
        Objects.requireNonNull(type, "returnType == null");
        Objects.requireNonNull(object, "annotations == null");
        int n2 = this.callAdapterFactories.indexOf(factory) + 1;
        int n3 = this.callAdapterFactories.size();
        for (n = n2; n < n3; ++n) {
            CallAdapter<?, ?> callAdapter = this.callAdapterFactories.get(n).get(type, (Annotation[])object, this);
            if (callAdapter == null) continue;
            return callAdapter;
        }
        object = new StringBuilder("Could not locate call adapter for ");
        ((StringBuilder)object).append(type);
        ((StringBuilder)object).append(".\n");
        if (factory != null) {
            ((StringBuilder)object).append("  Skipped:");
            for (n = 0; n < n2; ++n) {
                ((StringBuilder)object).append("\n   * ");
                ((StringBuilder)object).append(this.callAdapterFactories.get(n).getClass().getName());
            }
            ((StringBuilder)object).append('\n');
        }
        ((StringBuilder)object).append("  Tried:");
        n = this.callAdapterFactories.size();
        while (n2 < n) {
            ((StringBuilder)object).append("\n   * ");
            ((StringBuilder)object).append(this.callAdapterFactories.get(n2).getClass().getName());
            ++n2;
        }
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public <T> Converter<T, RequestBody> nextRequestBodyConverter(@Nullable Converter.Factory factory, Type type, Annotation[] object, Annotation[] annotationArray) {
        int n;
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(object, "parameterAnnotations == null");
        Objects.requireNonNull(annotationArray, "methodAnnotations == null");
        int n2 = this.converterFactories.indexOf(factory) + 1;
        int n3 = this.converterFactories.size();
        for (n = n2; n < n3; ++n) {
            Converter<?, RequestBody> converter = this.converterFactories.get(n).requestBodyConverter(type, (Annotation[])object, annotationArray, this);
            if (converter == null) continue;
            return converter;
        }
        object = new StringBuilder("Could not locate RequestBody converter for ");
        ((StringBuilder)object).append(type);
        ((StringBuilder)object).append(".\n");
        if (factory != null) {
            ((StringBuilder)object).append("  Skipped:");
            for (n = 0; n < n2; ++n) {
                ((StringBuilder)object).append("\n   * ");
                ((StringBuilder)object).append(this.converterFactories.get(n).getClass().getName());
            }
            ((StringBuilder)object).append('\n');
        }
        ((StringBuilder)object).append("  Tried:");
        n = this.converterFactories.size();
        while (n2 < n) {
            ((StringBuilder)object).append("\n   * ");
            ((StringBuilder)object).append(this.converterFactories.get(n2).getClass().getName());
            ++n2;
        }
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public <T> Converter<ResponseBody, T> nextResponseBodyConverter(@Nullable Converter.Factory factory, Type type, Annotation[] object) {
        int n;
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(object, "annotations == null");
        int n2 = this.converterFactories.indexOf(factory) + 1;
        int n3 = this.converterFactories.size();
        for (n = n2; n < n3; ++n) {
            Converter<ResponseBody, ?> converter = this.converterFactories.get(n).responseBodyConverter(type, (Annotation[])object, this);
            if (converter == null) continue;
            return converter;
        }
        object = new StringBuilder("Could not locate ResponseBody converter for ");
        ((StringBuilder)object).append(type);
        ((StringBuilder)object).append(".\n");
        if (factory != null) {
            ((StringBuilder)object).append("  Skipped:");
            for (n = 0; n < n2; ++n) {
                ((StringBuilder)object).append("\n   * ");
                ((StringBuilder)object).append(this.converterFactories.get(n).getClass().getName());
            }
            ((StringBuilder)object).append('\n');
        }
        ((StringBuilder)object).append("  Tried:");
        n = this.converterFactories.size();
        while (n2 < n) {
            ((StringBuilder)object).append("\n   * ");
            ((StringBuilder)object).append(this.converterFactories.get(n2).getClass().getName());
            ++n2;
        }
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public <T> Converter<T, RequestBody> requestBodyConverter(Type type, Annotation[] annotationArray, Annotation[] annotationArray2) {
        return this.nextRequestBodyConverter(null, type, annotationArray, annotationArray2);
    }

    public <T> Converter<ResponseBody, T> responseBodyConverter(Type type, Annotation[] annotationArray) {
        return this.nextResponseBodyConverter(null, type, annotationArray);
    }

    public <T> Converter<T, String> stringConverter(Type type, Annotation[] annotationArray) {
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(annotationArray, "annotations == null");
        int n = this.converterFactories.size();
        for (int i = 0; i < n; ++i) {
            Converter<?, String> converter = this.converterFactories.get(i).stringConverter(type, annotationArray, this);
            if (converter == null) continue;
            return converter;
        }
        return BuiltInConverters.ToStringConverter.INSTANCE;
    }

    public static final class Builder {
        @Nullable
        private HttpUrl baseUrl;
        private final List<CallAdapter.Factory> callAdapterFactories;
        @Nullable
        private Call.Factory callFactory;
        @Nullable
        private Executor callbackExecutor;
        private final List<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>();
        private final Platform platform;
        private boolean validateEagerly;

        public Builder() {
            this(Platform.get());
        }

        Builder(Platform platform) {
            this.callAdapterFactories = new ArrayList<CallAdapter.Factory>();
            this.platform = platform;
        }

        Builder(Retrofit retrofit) {
            int n;
            Platform platform;
            this.callAdapterFactories = new ArrayList<CallAdapter.Factory>();
            this.platform = platform = Platform.get();
            this.callFactory = retrofit.callFactory;
            this.baseUrl = retrofit.baseUrl;
            int n2 = retrofit.converterFactories.size();
            int n3 = platform.defaultConverterFactoriesSize();
            for (n = 1; n < n2 - n3; ++n) {
                this.converterFactories.add(retrofit.converterFactories.get(n));
            }
            n3 = retrofit.callAdapterFactories.size();
            n2 = this.platform.defaultCallAdapterFactoriesSize();
            for (n = 0; n < n3 - n2; ++n) {
                this.callAdapterFactories.add(retrofit.callAdapterFactories.get(n));
            }
            this.callbackExecutor = retrofit.callbackExecutor;
            this.validateEagerly = retrofit.validateEagerly;
        }

        public Builder addCallAdapterFactory(CallAdapter.Factory factory) {
            List<CallAdapter.Factory> list = this.callAdapterFactories;
            Objects.requireNonNull(factory, "factory == null");
            CallAdapter.Factory factory2 = factory;
            list.add(factory);
            return this;
        }

        public Builder addConverterFactory(Converter.Factory factory) {
            List<Converter.Factory> list = this.converterFactories;
            Objects.requireNonNull(factory, "factory == null");
            Converter.Factory factory2 = factory;
            list.add(factory);
            return this;
        }

        public Builder baseUrl(String string2) {
            Objects.requireNonNull(string2, "baseUrl == null");
            return this.baseUrl(HttpUrl.get(string2));
        }

        public Builder baseUrl(URL uRL) {
            Objects.requireNonNull(uRL, "baseUrl == null");
            return this.baseUrl(HttpUrl.get(uRL.toString()));
        }

        public Builder baseUrl(HttpUrl httpUrl) {
            Objects.requireNonNull(httpUrl, "baseUrl == null");
            Object object = httpUrl.pathSegments();
            if ("".equals(object.get(object.size() - 1))) {
                this.baseUrl = httpUrl;
                return this;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("baseUrl must end in /: ");
            ((StringBuilder)object).append(httpUrl);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public Retrofit build() {
            if (this.baseUrl != null) {
                Object object;
                Object object2 = this.callFactory;
                Call.Factory factory = object2;
                if (object2 == null) {
                    factory = new OkHttpClient();
                }
                object2 = object = this.callbackExecutor;
                if (object == null) {
                    object2 = this.platform.defaultCallbackExecutor();
                }
                object = new ArrayList<CallAdapter.Factory>(this.callAdapterFactories);
                object.addAll(this.platform.defaultCallAdapterFactories((Executor)object2));
                ArrayList<? extends Converter.Factory> arrayList = new ArrayList<Converter.Factory>(this.converterFactories.size() + 1 + this.platform.defaultConverterFactoriesSize());
                arrayList.add(new BuiltInConverters());
                arrayList.addAll(this.converterFactories);
                arrayList.addAll(this.platform.defaultConverterFactories());
                return new Retrofit(factory, this.baseUrl, Collections.unmodifiableList(arrayList), Collections.unmodifiableList(object), (Executor)object2, this.validateEagerly);
            }
            throw new IllegalStateException("Base URL required.");
        }

        public List<CallAdapter.Factory> callAdapterFactories() {
            return this.callAdapterFactories;
        }

        public Builder callFactory(Call.Factory factory) {
            Objects.requireNonNull(factory, "factory == null");
            Call.Factory factory2 = factory;
            this.callFactory = factory;
            return this;
        }

        public Builder callbackExecutor(Executor executor) {
            Objects.requireNonNull(executor, "executor == null");
            Executor executor2 = executor;
            this.callbackExecutor = executor;
            return this;
        }

        public Builder client(OkHttpClient okHttpClient) {
            Objects.requireNonNull(okHttpClient, "client == null");
            return this.callFactory(okHttpClient);
        }

        public List<Converter.Factory> converterFactories() {
            return this.converterFactories;
        }

        public Builder validateEagerly(boolean bl) {
            this.validateEagerly = bl;
            return this;
        }
    }
}

