/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import retrofit2.HttpServiceMethod;
import retrofit2.RequestFactory;
import retrofit2.Retrofit;
import retrofit2.Utils;

abstract class ServiceMethod<T> {
    ServiceMethod() {
    }

    static <T> ServiceMethod<T> parseAnnotations(Retrofit retrofit, Method method) {
        RequestFactory requestFactory = RequestFactory.parseAnnotations(retrofit, method);
        Type type = method.getGenericReturnType();
        if (!Utils.hasUnresolvableType(type)) {
            if (type != Void.TYPE) {
                return HttpServiceMethod.parseAnnotations(retrofit, method, requestFactory);
            }
            throw Utils.methodError(method, "Service methods cannot return void.", new Object[0]);
        }
        throw Utils.methodError(method, "Method return type must not include a type variable or wildcard: %s", type);
    }

    @Nullable
    abstract T invoke(Object[] var1);
}

