/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import okio.Buffer;

final class Utils {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private Utils() {
    }

    static ResponseBody buffer(ResponseBody responseBody) throws IOException {
        Buffer buffer = new Buffer();
        responseBody.source().readAll(buffer);
        return ResponseBody.create(responseBody.contentType(), responseBody.contentLength(), buffer);
    }

    static void checkNotPrimitive(Type type) {
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            throw new IllegalArgumentException();
        }
    }

    @Nullable
    private static Class<?> declaringClassOf(TypeVariable<?> type) {
        type = (type = type.getGenericDeclaration()) instanceof Class ? (Class)type : null;
        return type;
    }

    static boolean equals(Type type, Type type2) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (type == type2) {
            return true;
        }
        if (type instanceof Class) {
            return type.equals(type2);
        }
        if (type instanceof ParameterizedType) {
            Type type3;
            if (!(type2 instanceof ParameterizedType)) {
                return false;
            }
            type = (ParameterizedType)type;
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            type2 = type.getOwnerType();
            if (!((type2 == (type3 = parameterizedType.getOwnerType()) || type2 != null && type2.equals(type3)) && type.getRawType().equals(parameterizedType.getRawType()) && Arrays.equals(type.getActualTypeArguments(), parameterizedType.getActualTypeArguments()))) {
                bl3 = false;
            }
            return bl3;
        }
        if (type instanceof GenericArrayType) {
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            type = (GenericArrayType)type;
            type2 = (GenericArrayType)type2;
            return Utils.equals(type.getGenericComponentType(), type2.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            if (!(type2 instanceof WildcardType)) {
                return false;
            }
            type = (WildcardType)type;
            type2 = (WildcardType)type2;
            bl3 = Arrays.equals(type.getUpperBounds(), type2.getUpperBounds()) && Arrays.equals(type.getLowerBounds(), type2.getLowerBounds()) ? bl : false;
            return bl3;
        }
        if (type instanceof TypeVariable) {
            if (!(type2 instanceof TypeVariable)) {
                return false;
            }
            type = (TypeVariable)type;
            type2 = (TypeVariable)type2;
            bl3 = type.getGenericDeclaration() == type2.getGenericDeclaration() && type.getName().equals(type2.getName()) ? bl2 : false;
            return bl3;
        }
        return false;
    }

    static Type getGenericSupertype(Type object, Class<?> object2, Class<?> clazz) {
        if (clazz == object2) {
            return object;
        }
        if (clazz.isInterface()) {
            object = ((Class)object2).getInterfaces();
            int n = ((Class<?>[])object).length;
            for (int i = 0; i < n; ++i) {
                if (object[i] == clazz) {
                    return ((Class)object2).getGenericInterfaces()[i];
                }
                if (!clazz.isAssignableFrom(object[i])) continue;
                return Utils.getGenericSupertype(((Class)object2).getGenericInterfaces()[i], object[i], clazz);
            }
        }
        if (!((Class)object2).isInterface()) {
            while (object2 != Object.class) {
                object = ((Class)object2).getSuperclass();
                if (object == clazz) {
                    return ((Class)object2).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object)) {
                    return Utils.getGenericSupertype(((Class)object2).getGenericSuperclass(), object, clazz);
                }
                object2 = object;
            }
        }
        return clazz;
    }

    static Type getParameterLowerBound(int n, ParameterizedType type) {
        Type type2 = type.getActualTypeArguments()[n];
        type = type2;
        if (type2 instanceof WildcardType) {
            type = ((WildcardType)type2).getLowerBounds()[0];
        }
        return type;
    }

    static Type getParameterUpperBound(int n, ParameterizedType object) {
        Object object2 = object.getActualTypeArguments();
        if (n >= 0 && n < ((Type[])object2).length) {
            object = object2 = object2[n];
            if (object2 instanceof WildcardType) {
                object = ((WildcardType)object2).getUpperBounds()[0];
            }
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Index ");
        stringBuilder.append(n);
        stringBuilder.append(" not in range [0,");
        stringBuilder.append(((Type[])object2).length);
        stringBuilder.append(") for ");
        stringBuilder.append(object);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    static Class<?> getRawType(Type type) {
        Objects.requireNonNull(type, "type == null");
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            if ((type = ((ParameterizedType)type).getRawType()) instanceof Class) {
                return (Class)type;
            }
            throw new IllegalArgumentException();
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(Utils.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return Utils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a Class, ParameterizedType, or GenericArrayType, but <");
        stringBuilder.append(type);
        stringBuilder.append("> is of type ");
        stringBuilder.append(type.getClass().getName());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    static Type getSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isAssignableFrom(clazz)) {
            return Utils.resolve(type, clazz, Utils.getGenericSupertype(type, clazz, clazz2));
        }
        throw new IllegalArgumentException();
    }

    static boolean hasUnresolvableType(@Nullable Type typeArray) {
        if (typeArray instanceof Class) {
            return false;
        }
        if (typeArray instanceof ParameterizedType) {
            typeArray = ((ParameterizedType)typeArray).getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                if (!Utils.hasUnresolvableType(typeArray[i])) continue;
                return true;
            }
            return false;
        }
        if (typeArray instanceof GenericArrayType) {
            return Utils.hasUnresolvableType(((GenericArrayType)typeArray).getGenericComponentType());
        }
        if (typeArray instanceof TypeVariable) {
            return true;
        }
        if (typeArray instanceof WildcardType) {
            return true;
        }
        String string2 = typeArray == null ? "null" : typeArray.getClass().getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a Class, ParameterizedType, or GenericArrayType, but <");
        stringBuilder.append(typeArray);
        stringBuilder.append("> is of type ");
        stringBuilder.append(string2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private static int indexOf(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    static boolean isAnnotationPresent(Annotation[] annotationArray, Class<? extends Annotation> clazz) {
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            if (!clazz.isInstance(annotationArray[i])) continue;
            return true;
        }
        return false;
    }

    static RuntimeException methodError(Method method, String string2, Object ... objectArray) {
        return Utils.methodError(method, null, string2, objectArray);
    }

    static RuntimeException methodError(Method method, @Nullable Throwable throwable, String charSequence, Object ... object) {
        object = String.format((String)charSequence, object);
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append((String)object);
        ((StringBuilder)charSequence).append("\n    for method ");
        ((StringBuilder)charSequence).append(method.getDeclaringClass().getSimpleName());
        ((StringBuilder)charSequence).append(".");
        ((StringBuilder)charSequence).append(method.getName());
        return new IllegalArgumentException(((StringBuilder)charSequence).toString(), throwable);
    }

    static RuntimeException parameterError(Method method, int n, String string2, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" (parameter #");
        stringBuilder.append(n + 1);
        stringBuilder.append(")");
        return Utils.methodError(method, stringBuilder.toString(), objectArray);
    }

    static RuntimeException parameterError(Method method, Throwable throwable, int n, String string2, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" (parameter #");
        stringBuilder.append(n + 1);
        stringBuilder.append(")");
        return Utils.methodError(method, throwable, stringBuilder.toString(), objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Type resolve(Type type, Class<?> typeArray, Type type2) {
        Type type3;
        while (type2 instanceof TypeVariable) {
            type3 = (TypeVariable)type2;
            if ((type2 = Utils.resolveTypeVariable(type, typeArray, type3)) != type3) continue;
            return type2;
        }
        if (type2 instanceof Class && ((Class)(type3 = (Class)type2)).isArray()) {
            type2 = ((Class)type3).getComponentType();
            if (type2 != (type = Utils.resolve(type, typeArray, type2))) return new GenericArrayTypeImpl(type);
            return type3;
        }
        if (type2 instanceof GenericArrayType) {
            type3 = (type2 = (GenericArrayType)type2).getGenericComponentType();
            if (type3 != (type = Utils.resolve(type, typeArray, type3))) return new GenericArrayTypeImpl(type);
            return type2;
        }
        boolean bl = type2 instanceof ParameterizedType;
        if (bl) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Type type4 = Utils.resolve(type, typeArray, type2 = parameterizedType.getOwnerType());
            boolean bl2 = type4 != type2;
            type2 = parameterizedType.getActualTypeArguments();
            int n = ((Type)type2).length;
            for (int i = 0; i < n; ++i) {
                Type type5 = Utils.resolve(type, typeArray, type2[i]);
                boolean bl3 = bl2;
                type3 = type2;
                if (type5 != type2[i]) {
                    bl3 = bl2;
                    type3 = type2;
                    if (!bl2) {
                        type3 = (Type[])type2.clone();
                        bl3 = true;
                    }
                    type3[i] = type5;
                }
                bl2 = bl3;
                type2 = type3;
            }
            type = parameterizedType;
            if (!bl2) return type;
            return new ParameterizedTypeImpl(type4, parameterizedType.getRawType(), (Type[])type2);
        }
        type3 = type2;
        if (!(type2 instanceof WildcardType)) return type3;
        type2 = (WildcardType)type2;
        Type[] typeArray2 = type2.getLowerBounds();
        Type[] typeArray3 = type2.getUpperBounds();
        if (typeArray2.length == 1) {
            type = Utils.resolve(type, typeArray, typeArray2[0]);
            type3 = type2;
            if (type == typeArray2[0]) return type3;
            return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{type});
        }
        type3 = type2;
        if (typeArray3.length != 1) return type3;
        type3 = typeArray3[0];
        type = Utils.resolve(type, typeArray, type3);
        type3 = type2;
        if (type == typeArray3[0]) return type3;
        typeArray = EMPTY_TYPE_ARRAY;
        return new WildcardTypeImpl(new Type[]{type}, typeArray);
    }

    private static Type resolveTypeVariable(Type type, Class<?> clazz, TypeVariable<?> typeVariable) {
        Class<?> clazz2 = Utils.declaringClassOf(typeVariable);
        if (clazz2 == null) {
            return typeVariable;
        }
        if ((type = Utils.getGenericSupertype(type, clazz, clazz2)) instanceof ParameterizedType) {
            int n = Utils.indexOf(clazz2.getTypeParameters(), typeVariable);
            return ((ParameterizedType)type).getActualTypeArguments()[n];
        }
        return typeVariable;
    }

    static void throwIfFatal(Throwable throwable) {
        if (!(throwable instanceof VirtualMachineError)) {
            if (!(throwable instanceof ThreadDeath)) {
                if (!(throwable instanceof LinkageError)) {
                    return;
                }
                throw (LinkageError)throwable;
            }
            throw (ThreadDeath)throwable;
        }
        throw (VirtualMachineError)throwable;
    }

    static String typeToString(Type object) {
        object = object instanceof Class ? ((Class)object).getName() : object.toString();
        return object;
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        GenericArrayTypeImpl(Type type) {
            this.componentType = type;
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof GenericArrayType && Utils.equals(this, (GenericArrayType)object);
            return bl;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Utils.typeToString(this.componentType));
            stringBuilder.append("[]");
            return stringBuilder.toString();
        }
    }

    static final class ParameterizedTypeImpl
    implements ParameterizedType {
        @Nullable
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;

        ParameterizedTypeImpl(@Nullable Type type, Type type2, Type ... typeArray) {
            int n;
            int n2;
            boolean bl = type2 instanceof Class;
            int n3 = 0;
            if (bl) {
                n2 = 1;
                n = type == null ? 1 : 0;
                if (((Class)type2).getEnclosingClass() != null) {
                    n2 = 0;
                }
                if (n != n2) {
                    throw new IllegalArgumentException();
                }
            }
            n2 = typeArray.length;
            for (n = n3; n < n2; ++n) {
                Type type3 = typeArray[n];
                Objects.requireNonNull(type3, "typeArgument == null");
                Utils.checkNotPrimitive(type3);
            }
            this.ownerType = type;
            this.rawType = type2;
            this.typeArguments = (Type[])typeArray.clone();
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof ParameterizedType && Utils.equals(this, (ParameterizedType)object);
            return bl;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            int n = Arrays.hashCode(this.typeArguments);
            int n2 = this.rawType.hashCode();
            Type type = this.ownerType;
            int n3 = type != null ? type.hashCode() : 0;
            return n ^ n2 ^ n3;
        }

        public String toString() {
            Object object = this.typeArguments;
            if (((Type[])object).length == 0) {
                return Utils.typeToString(this.rawType);
            }
            int n = ((Type[])object).length;
            object = new StringBuilder((n + 1) * 30);
            ((StringBuilder)object).append(Utils.typeToString(this.rawType));
            ((StringBuilder)object).append("<");
            ((StringBuilder)object).append(Utils.typeToString(this.typeArguments[0]));
            for (int i = 1; i < this.typeArguments.length; ++i) {
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(Utils.typeToString(this.typeArguments[i]));
            }
            ((StringBuilder)object).append(">");
            return ((StringBuilder)object).toString();
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType {
        @Nullable
        private final Type lowerBound;
        private final Type upperBound;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            if (typeArray2.length > 1) throw new IllegalArgumentException();
            if (typeArray.length != 1) throw new IllegalArgumentException();
            if (typeArray2.length == 1) {
                Objects.requireNonNull(typeArray2[0]);
                Utils.checkNotPrimitive(typeArray2[0]);
                if (typeArray[0] != Object.class) throw new IllegalArgumentException();
                this.lowerBound = typeArray2[0];
                this.upperBound = Object.class;
                return;
            } else {
                Objects.requireNonNull(typeArray[0]);
                Utils.checkNotPrimitive(typeArray[0]);
                this.lowerBound = null;
                this.upperBound = typeArray[0];
            }
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof WildcardType && Utils.equals(this, (WildcardType)object);
            return bl;
        }

        @Override
        public Type[] getLowerBounds() {
            Type type = this.lowerBound;
            Type[] typeArray = type != null ? new Type[]{type} : EMPTY_TYPE_ARRAY;
            return typeArray;
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        public int hashCode() {
            Type type = this.lowerBound;
            int n = type != null ? type.hashCode() + 31 : 1;
            return n ^ this.upperBound.hashCode() + 31;
        }

        public String toString() {
            if (this.lowerBound != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("? super ");
                stringBuilder.append(Utils.typeToString(this.lowerBound));
                return stringBuilder.toString();
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("? extends ");
            stringBuilder.append(Utils.typeToString(this.upperBound));
            return stringBuilder.toString();
        }
    }
}

