/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.gson;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Converter;

final class GsonResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private final TypeAdapter<T> adapter;
    private final Gson gson;

    GsonResponseBodyConverter(Gson gson, TypeAdapter<T> typeAdapter) {
        this.gson = gson;
        this.adapter = typeAdapter;
    }

    @Override
    public T convert(ResponseBody responseBody) throws IOException {
        Object object;
        block3: {
            JsonReader jsonReader = this.gson.newJsonReader(responseBody.charStream());
            try {
                object = this.adapter.read(jsonReader);
                JsonToken jsonToken = jsonReader.peek();
                jsonReader = JsonToken.END_DOCUMENT;
                if (jsonToken != jsonReader) break block3;
                responseBody.close();
            }
            catch (Throwable throwable) {
                responseBody.close();
                throw throwable;
            }
            return (T)object;
        }
        object = new JsonIOException("JSON document was not fully consumed.");
        throw object;
    }
}

