/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Map;
import java.util.Properties;
import sun.misc.OSEnvironment;
import sun.misc.VMNotification;

public class VM {
    private static final int JVMTI_THREAD_STATE_ALIVE = 1;
    private static final int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static final int JVMTI_THREAD_STATE_RUNNABLE = 4;
    private static final int JVMTI_THREAD_STATE_TERMINATED = 2;
    private static final int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static final int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;
    @Deprecated
    public static final int STATE_GREEN = 1;
    @Deprecated
    public static final int STATE_RED = 3;
    @Deprecated
    public static final int STATE_YELLOW = 2;
    private static boolean allowArraySyntax = false;
    private static boolean allowGetCallerClass = true;
    private static volatile boolean booted = false;
    private static boolean defaultAllowArraySyntax = false;
    private static long directMemory = 0x4000000L;
    private static volatile int finalRefCount = 0;
    private static boolean pageAlignDirectMemory = false;
    private static volatile int peakFinalRefCount = 0;
    private static final Properties savedProps = new Properties();
    private static boolean suspended = false;

    static {
        finalRefCount = 0;
        peakFinalRefCount = 0;
        VM.initialize();
    }

    public static void addFinalRefCount(int n) {
        if ((finalRefCount += n) > peakFinalRefCount) {
            peakFinalRefCount = finalRefCount;
        }
    }

    public static boolean allowArraySyntax() {
        return allowArraySyntax;
    }

    public static boolean allowGetCallerClass() {
        return allowGetCallerClass;
    }

    public static boolean allowThreadSuspension(ThreadGroup threadGroup, boolean bl) {
        return threadGroup.allowThreadSuspension(bl);
    }

    @Deprecated
    public static void asChange(int n, int n2) {
    }

    @Deprecated
    public static void asChange_otherthread(int n, int n2) {
    }

    public static void booted() {
        booted = true;
    }

    public static int getFinalRefCount() {
        return finalRefCount;
    }

    public static int getPeakFinalRefCount() {
        return peakFinalRefCount;
    }

    public static String getSavedProperty(String string2) {
        Properties properties = savedProps;
        if (!properties.isEmpty()) {
            return properties.getProperty(string2);
        }
        throw new IllegalStateException("Should be non-empty if initialized");
    }

    @Deprecated
    public static final int getState() {
        return 1;
    }

    private static native void initialize();

    public static void initializeOSEnvironment() {
        if (!booted) {
            OSEnvironment.initialize();
        }
    }

    public static boolean isBooted() {
        return booted;
    }

    public static boolean isDirectMemoryPageAligned() {
        return pageAlignDirectMemory;
    }

    public static native ClassLoader latestUserDefinedLoader();

    public static long maxDirectMemory() {
        return directMemory;
    }

    @Deprecated
    public static void registerVMNotification(VMNotification vMNotification) {
    }

    public static void saveAndRemoveProperties(Properties properties) {
        if (!booted) {
            savedProps.putAll((Map<?, ?>)properties);
            String string2 = (String)properties.remove("sun.nio.MaxDirectMemorySize");
            if (string2 != null) {
                if (string2.equals("-1")) {
                    directMemory = Runtime.getRuntime().maxMemory();
                } else {
                    long l = Long.parseLong(string2);
                    if (l > -1L) {
                        directMemory = l;
                    }
                }
            }
            boolean bl = "true".equals((String)properties.remove("sun.nio.PageAlignDirectMemory"));
            boolean bl2 = true;
            if (bl) {
                pageAlignDirectMemory = true;
            }
            bl = (string2 = properties.getProperty("sun.lang.ClassLoader.allowArraySyntax")) == null ? defaultAllowArraySyntax : Boolean.parseBoolean(string2);
            allowArraySyntax = bl;
            string2 = properties.getProperty("jdk.reflect.allowGetCallerClass");
            bl = bl2;
            if (string2 != null) {
                bl = bl2;
                if (!string2.isEmpty()) {
                    bl = Boolean.parseBoolean(string2) ? bl2 : (Boolean.valueOf(properties.getProperty("jdk.logging.allowStackWalkSearch")) != false ? bl2 : false);
                }
            }
            allowGetCallerClass = bl;
            properties.remove("java.lang.Integer.IntegerCache.high");
            properties.remove("sun.zip.disableMemoryMapping");
            properties.remove("sun.java.launcher.diag");
            return;
        }
        throw new IllegalStateException("System initialization has completed");
    }

    @Deprecated
    public static boolean suspendThreads() {
        suspended = true;
        return true;
    }

    @Deprecated
    public static boolean threadsSuspended() {
        return suspended;
    }

    public static Thread.State toThreadState(int n) {
        if ((n & 4) != 0) {
            return Thread.State.RUNNABLE;
        }
        if ((n & 0x400) != 0) {
            return Thread.State.BLOCKED;
        }
        if ((n & 0x10) != 0) {
            return Thread.State.WAITING;
        }
        if ((n & 0x20) != 0) {
            return Thread.State.TIMED_WAITING;
        }
        if ((n & 2) != 0) {
            return Thread.State.TERMINATED;
        }
        if ((n & 1) == 0) {
            return Thread.State.NEW;
        }
        return Thread.State.RUNNABLE;
    }

    @Deprecated
    public static void unsuspendSomeThreads() {
    }

    @Deprecated
    public static void unsuspendThreads() {
        suspended = false;
    }
}

