/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import sun.misc.VM;
import sun.reflect.CallerSensitive;

public class Reflection {
    private static volatile Map<Class, String[]> fieldFilterMap;
    private static volatile Map<Class, String[]> methodFilterMap;

    static {
        HashMap<Class, String[]> hashMap = new HashMap<Class, String[]>();
        hashMap.put(Reflection.class, new String[]{"fieldFilterMap", "methodFilterMap"});
        hashMap.put(System.class, new String[]{"security"});
        fieldFilterMap = hashMap;
        methodFilterMap = new HashMap<Class, String[]>();
    }

    public static void ensureMemberAccess(Class clazz, Class clazz2, Object object, int n) throws IllegalAccessException {
        if (clazz != null && clazz2 != null) {
            if (Reflection.verifyMemberAccess(clazz, clazz2, object, n)) {
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Class ");
            ((StringBuilder)object).append(clazz.getName());
            ((StringBuilder)object).append(" can not access a member of class ");
            ((StringBuilder)object).append(clazz2.getName());
            ((StringBuilder)object).append(" with modifiers \"");
            ((StringBuilder)object).append(Modifier.toString(n));
            ((StringBuilder)object).append("\"");
            throw new IllegalAccessException(((StringBuilder)object).toString());
        }
        throw new InternalError();
    }

    private static Member[] filter(Member[] memberArray, String[] stringArray) {
        if (stringArray != null && memberArray.length != 0) {
            int n;
            Member member;
            int n2;
            int n3 = memberArray.length;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                block8: {
                    n2 = 1;
                    if (n4 >= n3) break;
                    member = memberArray[n4];
                    for (String string2 : stringArray) {
                        if (member.getName() != string2) {
                            continue;
                        }
                        break block8;
                    }
                    n2 = 0;
                }
                n = n5;
                if (n2 == 0) {
                    n = n5 + 1;
                }
                ++n4;
                n5 = n;
            }
            Member[] memberArray2 = (Member[])Array.newInstance(memberArray[0].getClass(), n5);
            n3 = memberArray.length;
            n4 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                block9: {
                    member = memberArray[n5];
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String string2;
                        string2 = stringArray[n];
                        if (member.getName() != string2) continue;
                        n2 = 1;
                        break block9;
                    }
                    n2 = 0;
                }
                n = n4;
                if (n2 == 0) {
                    memberArray2[n4] = member;
                    n = n4 + 1;
                }
                n4 = n;
            }
            return memberArray2;
        }
        return memberArray;
    }

    public static Field[] filterFields(Class clazz, Field[] fieldArray) {
        if (fieldFilterMap == null) {
            return fieldArray;
        }
        return (Field[])Reflection.filter(fieldArray, fieldFilterMap.get(clazz));
    }

    public static Method[] filterMethods(Class clazz, Method[] methodArray) {
        if (methodFilterMap == null) {
            return methodArray;
        }
        return (Method[])Reflection.filter(methodArray, methodFilterMap.get(clazz));
    }

    @CallerSensitive
    public static native Class getCallerClass();

    @Deprecated
    @CallerSensitive
    public static Class getCallerClass(int n) {
        if (VM.allowGetCallerClass()) {
            return Reflection.getCallerClass0(n + 1);
        }
        throw new UnsupportedOperationException("This method has been disabled by a system property");
    }

    @CallerSensitive
    private static native Class getCallerClass0(int var0);

    private static native int getClassAccessFlags(Class var0);

    public static boolean isCallerSensitive(Method method) {
        ClassLoader classLoader = method.getDeclaringClass().getClassLoader();
        if (classLoader != null && !Reflection.isExtClassLoader(classLoader)) {
            return false;
        }
        return method.isAnnotationPresent(CallerSensitive.class);
    }

    private static boolean isExtClassLoader(ClassLoader classLoader) {
        for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            if (classLoader2.getParent() != null || classLoader2 != classLoader) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameClassPackage(Class clazz, Class clazz2) {
        return Reflection.isSameClassPackage(clazz.getClassLoader(), clazz.getName(), clazz2.getClassLoader(), clazz2.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isSameClassPackage(ClassLoader object, String string2, ClassLoader classLoader, String string3) {
        boolean bl = false;
        if (object != classLoader) {
            return false;
        }
        int n = string2.lastIndexOf(46);
        int n2 = string3.lastIndexOf(46);
        if (n != -1 && n2 != -1) {
            int n3;
            int n4;
            int n5;
            if (string2.charAt(0) == '[') {
                n5 = 0;
                do {
                    n5 = n4 = n5 + 1;
                } while (string2.charAt(n4) == '[');
                if (string2.charAt(n4) != 'L') {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Illegal class name ");
                    ((StringBuilder)object).append(string2);
                    throw new InternalError(((StringBuilder)object).toString());
                }
                n5 = n4;
            } else {
                n5 = 0;
            }
            if (string3.charAt(0) == '[') {
                n4 = 0;
                do {
                    n4 = n3 = n4 + 1;
                } while (string3.charAt(n3) == '[');
                if (string3.charAt(n3) != 'L') {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Illegal class name ");
                    ((StringBuilder)object).append(string3);
                    throw new InternalError(((StringBuilder)object).toString());
                }
                n4 = n3;
            } else {
                n4 = 0;
            }
            n3 = n - n5;
            if (n3 == n2 - n4) return string2.regionMatches(false, n5, string3, n4, n3);
            return false;
        }
        if (n != n2) return bl;
        return true;
    }

    static boolean isSubclassOf(Class clazz, Class clazz2) {
        while (clazz != null) {
            if (clazz == clazz2) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static boolean quickCheckMemberAccess(Class clazz, int n) {
        return Modifier.isPublic(Reflection.getClassAccessFlags(clazz) & n);
    }

    public static void registerFieldsToFilter(Class clazz, String ... stringArray) {
        synchronized (Reflection.class) {
            fieldFilterMap = Reflection.registerFilter(fieldFilterMap, clazz, stringArray);
            return;
        }
    }

    private static Map<Class, String[]> registerFilter(Map<Class, String[]> hashMap, Class clazz, String ... stringArray) {
        if (hashMap.get(clazz) == null) {
            hashMap = new HashMap<Class, String[]>(hashMap);
            hashMap.put(clazz, stringArray);
            return hashMap;
        }
        hashMap = new StringBuilder();
        ((StringBuilder)((Object)hashMap)).append("Filter already registered: ");
        ((StringBuilder)((Object)hashMap)).append(clazz);
        throw new IllegalArgumentException(((StringBuilder)((Object)hashMap)).toString());
    }

    public static void registerMethodsToFilter(Class clazz, String ... stringArray) {
        synchronized (Reflection.class) {
            methodFilterMap = Reflection.registerFilter(methodFilterMap, clazz, stringArray);
            return;
        }
    }

    public static boolean verifyMemberAccess(Class clazz, Class clazz2, Object clazz3, int n) {
        boolean bl;
        boolean bl2;
        if (clazz == clazz2) {
            return true;
        }
        if (!Modifier.isPublic(Reflection.getClassAccessFlags(clazz2))) {
            bl2 = Reflection.isSameClassPackage(clazz, clazz2);
            if (!bl2) {
                return false;
            }
            bl = true;
        } else {
            bl2 = false;
            bl = false;
        }
        if (Modifier.isPublic(n)) {
            return true;
        }
        boolean bl3 = Modifier.isProtected(n) && Reflection.isSubclassOf(clazz, clazz2);
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = bl3;
        if (!bl3) {
            bl4 = bl2;
            bl5 = bl;
            bl6 = bl3;
            if (!Modifier.isPrivate(n)) {
                boolean bl7 = bl;
                if (!bl) {
                    bl2 = Reflection.isSameClassPackage(clazz, clazz2);
                    bl7 = true;
                }
                bl4 = bl2;
                bl5 = bl7;
                bl6 = bl3;
                if (bl2) {
                    bl6 = true;
                    bl5 = bl7;
                    bl4 = bl2;
                }
            }
        }
        if (!bl6) {
            return false;
        }
        if (Modifier.isProtected(n) && (clazz3 = clazz3 == null ? clazz2 : clazz3.getClass()) != clazz) {
            if (!bl5) {
                bl4 = Reflection.isSameClassPackage(clazz, clazz2);
            }
            if (!bl4 && !Reflection.isSubclassOf(clazz3, clazz)) {
                return false;
            }
        }
        return true;
    }
}

