/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import sun.security.util.PermissionFactory;

public final class SecurityConstants {
    public static final AllPermission ALL_PERMISSION = new AllPermission();
    public static final RuntimePermission CHECK_MEMBER_ACCESS_PERMISSION;
    public static final SecurityPermission CREATE_ACC_PERMISSION;
    public static final RuntimePermission CREATE_CLASSLOADER_PERMISSION;
    public static final String FILE_DELETE_ACTION = "delete";
    public static final String FILE_EXECUTE_ACTION = "execute";
    public static final String FILE_READLINK_ACTION = "readlink";
    public static final String FILE_READ_ACTION = "read";
    public static final String FILE_WRITE_ACTION = "write";
    public static final RuntimePermission GET_CLASSLOADER_PERMISSION;
    public static final SecurityPermission GET_COMBINER_PERMISSION;
    public static final NetPermission GET_COOKIEHANDLER_PERMISSION;
    public static final RuntimePermission GET_PD_PERMISSION;
    public static final SecurityPermission GET_POLICY_PERMISSION;
    public static final NetPermission GET_PROXYSELECTOR_PERMISSION;
    public static final NetPermission GET_RESPONSECACHE_PERMISSION;
    public static final RuntimePermission GET_STACK_TRACE_PERMISSION;
    public static final SocketPermission LOCAL_LISTEN_PERMISSION;
    public static final RuntimePermission MODIFY_THREADGROUP_PERMISSION;
    public static final RuntimePermission MODIFY_THREAD_PERMISSION;
    public static final String PROPERTY_READ_ACTION = "read";
    public static final String PROPERTY_RW_ACTION = "read,write";
    public static final String PROPERTY_WRITE_ACTION = "write";
    public static final NetPermission SET_COOKIEHANDLER_PERMISSION;
    public static final NetPermission SET_PROXYSELECTOR_PERMISSION;
    public static final NetPermission SET_RESPONSECACHE_PERMISSION;
    public static final String SOCKET_ACCEPT_ACTION = "accept";
    public static final String SOCKET_CONNECT_ACCEPT_ACTION = "connect,accept";
    public static final String SOCKET_CONNECT_ACTION = "connect";
    public static final String SOCKET_LISTEN_ACTION = "listen";
    public static final String SOCKET_RESOLVE_ACTION = "resolve";
    public static final NetPermission SPECIFY_HANDLER_PERMISSION;
    public static final RuntimePermission STOP_THREAD_PERMISSION;

    static {
        SPECIFY_HANDLER_PERMISSION = new NetPermission("specifyStreamHandler");
        SET_PROXYSELECTOR_PERMISSION = new NetPermission("setProxySelector");
        GET_PROXYSELECTOR_PERMISSION = new NetPermission("getProxySelector");
        SET_COOKIEHANDLER_PERMISSION = new NetPermission("setCookieHandler");
        GET_COOKIEHANDLER_PERMISSION = new NetPermission("getCookieHandler");
        SET_RESPONSECACHE_PERMISSION = new NetPermission("setResponseCache");
        GET_RESPONSECACHE_PERMISSION = new NetPermission("getResponseCache");
        CREATE_CLASSLOADER_PERMISSION = new RuntimePermission("createClassLoader");
        CHECK_MEMBER_ACCESS_PERMISSION = new RuntimePermission("accessDeclaredMembers");
        MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");
        MODIFY_THREADGROUP_PERMISSION = new RuntimePermission("modifyThreadGroup");
        GET_PD_PERMISSION = new RuntimePermission("getProtectionDomain");
        GET_CLASSLOADER_PERMISSION = new RuntimePermission("getClassLoader");
        STOP_THREAD_PERMISSION = new RuntimePermission("stopThread");
        GET_STACK_TRACE_PERMISSION = new RuntimePermission("getStackTrace");
        CREATE_ACC_PERMISSION = new SecurityPermission("createAccessControlContext");
        GET_COMBINER_PERMISSION = new SecurityPermission("getDomainCombiner");
        GET_POLICY_PERMISSION = new SecurityPermission("getPolicy");
        LOCAL_LISTEN_PERMISSION = new SocketPermission("localhost:1024-", SOCKET_LISTEN_ACTION);
    }

    private SecurityConstants() {
    }

    public static class AWT {
        public static final Permission ACCESS_CLIPBOARD_PERMISSION;
        public static final Permission ACCESS_SYSTEM_TRAY_PERMISSION;
        public static final Permission ALL_AWT_EVENTS_PERMISSION;
        private static final String AWTFactory = "sun.awt.AWTPermissionFactory";
        public static final Permission CHECK_AWT_EVENTQUEUE_PERMISSION;
        public static final Permission CREATE_ROBOT_PERMISSION;
        public static final Permission READ_DISPLAY_PIXELS_PERMISSION;
        public static final Permission SET_WINDOW_ALWAYS_ON_TOP_PERMISSION;
        public static final Permission TOOLKIT_MODALITY_PERMISSION;
        public static final Permission TOPLEVEL_WINDOW_PERMISSION;
        public static final Permission WATCH_MOUSE_PERMISSION;
        private static final PermissionFactory<?> factory;

        static {
            factory = AWT.permissionFactory();
            TOPLEVEL_WINDOW_PERMISSION = AWT.newAWTPermission("showWindowWithoutWarningBanner");
            ACCESS_CLIPBOARD_PERMISSION = AWT.newAWTPermission("accessClipboard");
            CHECK_AWT_EVENTQUEUE_PERMISSION = AWT.newAWTPermission("accessEventQueue");
            TOOLKIT_MODALITY_PERMISSION = AWT.newAWTPermission("toolkitModality");
            READ_DISPLAY_PIXELS_PERMISSION = AWT.newAWTPermission("readDisplayPixels");
            CREATE_ROBOT_PERMISSION = AWT.newAWTPermission("createRobot");
            WATCH_MOUSE_PERMISSION = AWT.newAWTPermission("watchMousePointer");
            SET_WINDOW_ALWAYS_ON_TOP_PERMISSION = AWT.newAWTPermission("setWindowAlwaysOnTop");
            ALL_AWT_EVENTS_PERMISSION = AWT.newAWTPermission("listenToAllAWTEvents");
            ACCESS_SYSTEM_TRAY_PERMISSION = AWT.newAWTPermission("accessSystemTray");
        }

        private AWT() {
        }

        private static Permission newAWTPermission(String string2) {
            return factory.newPermission(string2);
        }

        private static PermissionFactory<?> permissionFactory() {
            Object object = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Class<?> run() {
                    Class<?> clazz = null;
                    try {
                        Class<?> clazz2 = Class.forName(AWT.AWTFactory, true, null);
                        return clazz2;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return clazz;
                    }
                }
            });
            if (object != null) {
                try {
                    object = (PermissionFactory)((Class)object).newInstance();
                    return object;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError(illegalAccessException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    throw new InternalError(instantiationException.getMessage());
                }
            }
            return new FakeAWTPermissionFactory();
        }
    }

    private static class FakeAWTPermission
    extends BasicPermission {
        private static final long serialVersionUID = -1L;

        public FakeAWTPermission(String string2) {
            super(string2);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(\"java.awt.AWTPermission\" \"");
            stringBuilder.append(this.getName());
            stringBuilder.append("\")");
            return stringBuilder.toString();
        }
    }

    private static class FakeAWTPermissionFactory
    implements PermissionFactory<FakeAWTPermission> {
        private FakeAWTPermissionFactory() {
        }

        @Override
        public FakeAWTPermission newPermission(String string2) {
            return new FakeAWTPermission(string2);
        }
    }
}

