/*
 * Decompiled with CFR 0.152.
 */
package timber.log;

import android.os.Build;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Ltimber/log/Timber;", "", "()V", "DebugTree", "Forest", "Tree", "timber_release"}, k=1, mv={1, 5, 1}, xi=48)
public final class Timber {
    public static final Forest Forest = new Forest(null);
    private static volatile Tree[] treeArray;
    private static final ArrayList<Tree> trees;

    static {
        trees = new ArrayList();
        treeArray = new Tree[0];
    }

    private Timber() {
        throw new AssertionError();
    }

    @JvmStatic
    public static Tree asTree() {
        return Forest.asTree();
    }

    @JvmStatic
    public static void d(String string2, Object ... objectArray) {
        Forest.d(string2, objectArray);
    }

    @JvmStatic
    public static void d(Throwable throwable) {
        Forest.d(throwable);
    }

    @JvmStatic
    public static void d(Throwable throwable, String string2, Object ... objectArray) {
        Forest.d(throwable, string2, objectArray);
    }

    @JvmStatic
    public static void e(String string2, Object ... objectArray) {
        Forest.e(string2, objectArray);
    }

    @JvmStatic
    public static void e(Throwable throwable) {
        Forest.e(throwable);
    }

    @JvmStatic
    public static void e(Throwable throwable, String string2, Object ... objectArray) {
        Forest.e(throwable, string2, objectArray);
    }

    @JvmStatic
    public static final List<Tree> forest() {
        return Forest.forest();
    }

    @JvmStatic
    public static void i(String string2, Object ... objectArray) {
        Forest.i(string2, objectArray);
    }

    @JvmStatic
    public static void i(Throwable throwable) {
        Forest.i(throwable);
    }

    @JvmStatic
    public static void i(Throwable throwable, String string2, Object ... objectArray) {
        Forest.i(throwable, string2, objectArray);
    }

    @JvmStatic
    public static void log(int n, String string2, Object ... objectArray) {
        Forest.log(n, string2, objectArray);
    }

    @JvmStatic
    public static void log(int n, Throwable throwable) {
        Forest.log(n, throwable);
    }

    @JvmStatic
    public static void log(int n, Throwable throwable, String string2, Object ... objectArray) {
        Forest.log(n, throwable, string2, objectArray);
    }

    @JvmStatic
    public static final void plant(Tree tree) {
        Forest.plant(tree);
    }

    @JvmStatic
    public static final void plant(Tree ... treeArray) {
        Forest.plant(treeArray);
    }

    @JvmStatic
    public static final Tree tag(String string2) {
        return Forest.tag(string2);
    }

    @JvmStatic
    public static final int treeCount() {
        return Forest.treeCount();
    }

    @JvmStatic
    public static final void uproot(Tree tree) {
        Forest.uproot(tree);
    }

    @JvmStatic
    public static final void uprootAll() {
        Forest.uprootAll();
    }

    @JvmStatic
    public static void v(String string2, Object ... objectArray) {
        Forest.v(string2, objectArray);
    }

    @JvmStatic
    public static void v(Throwable throwable) {
        Forest.v(throwable);
    }

    @JvmStatic
    public static void v(Throwable throwable, String string2, Object ... objectArray) {
        Forest.v(throwable, string2, objectArray);
    }

    @JvmStatic
    public static void w(String string2, Object ... objectArray) {
        Forest.w(string2, objectArray);
    }

    @JvmStatic
    public static void w(Throwable throwable) {
        Forest.w(throwable);
    }

    @JvmStatic
    public static void w(Throwable throwable, String string2, Object ... objectArray) {
        Forest.w(throwable, string2, objectArray);
    }

    @JvmStatic
    public static void wtf(String string2, Object ... objectArray) {
        Forest.wtf(string2, objectArray);
    }

    @JvmStatic
    public static void wtf(Throwable throwable) {
        Forest.wtf(throwable);
    }

    @JvmStatic
    public static void wtf(Throwable throwable, String string2, Object ... objectArray) {
        Forest.wtf(throwable, string2, objectArray);
    }

    @Metadata(d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0014J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00058PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Ltimber/log/Timber$DebugTree;", "Ltimber/log/Timber$Tree;", "()V", "fqcnIgnore", "", "", "kotlin.jvm.PlatformType", "tag", "getTag$timber_release", "()Ljava/lang/String;", "createStackElementTag", "element", "Ljava/lang/StackTraceElement;", "log", "", "priority", "", "message", "t", "", "Companion", "timber_release"}, k=1, mv={1, 5, 1}, xi=48)
    public static class DebugTree
    extends Tree {
        private static final Pattern ANONYMOUS_CLASS;
        public static final Companion Companion;
        private static final int MAX_LOG_LENGTH = 4000;
        private static final int MAX_TAG_LENGTH = 23;
        private final List<String> fqcnIgnore = CollectionsKt.listOf((Object[])new String[]{Timber.class.getName(), Forest.class.getName(), Tree.class.getName(), DebugTree.class.getName()});

        static {
            Companion = new Companion(null);
            ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");
        }

        protected String createStackElementTag(StackTraceElement object) {
            Intrinsics.checkNotNullParameter(object, "element");
            object = ((StackTraceElement)object).getClassName();
            Intrinsics.checkNotNullExpressionValue(object, "element.className");
            object = StringsKt.substringAfterLast$default((String)object, '.', null, 2, null);
            Object object2 = ANONYMOUS_CLASS.matcher((CharSequence)object);
            if (((Matcher)object2).find()) {
                object = ((Matcher)object2).replaceAll("");
                Intrinsics.checkNotNullExpressionValue(object, "m.replaceAll(\"\")");
            }
            object2 = object;
            if (((String)object).length() > 23) {
                if (Build.VERSION.SDK_INT >= 26) {
                    object2 = object;
                } else {
                    Objects.requireNonNull(object, "null cannot be cast to non-null type java.lang.String");
                    object2 = ((String)object).substring(0, 23);
                    Intrinsics.checkNotNullExpressionValue(object2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                }
            }
            return object2;
        }

        @Override
        public String getTag$timber_release() {
            Object object;
            block2: {
                Object object2 = super.getTag$timber_release();
                object = object2;
                if (object2 == null) {
                    object = new Throwable().getStackTrace();
                    Intrinsics.checkNotNullExpressionValue(object, "Throwable().stackTrace");
                    object = object;
                    int n = ((Object[])object).length;
                    for (int i = 0; i < n; ++i) {
                        object2 = (StackTraceElement)object[i];
                        if (!(this.fqcnIgnore.contains(((StackTraceElement)object2).getClassName()) ^ true)) continue;
                        object = this.createStackElementTag((StackTraceElement)object2);
                        break block2;
                    }
                    throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                }
            }
            return object;
        }

        @Override
        protected void log(int n, String string2, String string3, Throwable object) {
            Intrinsics.checkNotNullParameter(string3, "message");
            if (string3.length() < 4000) {
                if (n == 7) {
                    Log.wtf((String)string2, (String)string3);
                } else {
                    Log.println((int)n, (String)string2, (String)string3);
                }
                return;
            }
            int n2 = 0;
            int n3 = string3.length();
            block0: while (n2 < n3) {
                int n4 = StringsKt.indexOf$default((CharSequence)string3, '\n', n2, false, 4, null);
                if (n4 == -1) {
                    n4 = n3;
                }
                while (true) {
                    int n5 = Math.min(n4, n2 + 4000);
                    object = string3.substring(n2, n5);
                    Intrinsics.checkNotNullExpressionValue(object, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    if (n == 7) {
                        Log.wtf((String)string2, (String)object);
                    } else {
                        Log.println((int)n, (String)string2, (String)object);
                    }
                    if (n5 >= n4) {
                        n2 = n5 + 1;
                        continue block0;
                    }
                    n2 = n5;
                }
            }
        }

        @Metadata(d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ltimber/log/Timber$DebugTree$Companion;", "", "()V", "ANONYMOUS_CLASS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "MAX_LOG_LENGTH", "", "MAX_TAG_LENGTH", "timber_release"}, k=1, mv={1, 5, 1}, xi=48)
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }

    @Metadata(d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u000b\u001a\u00020\u0001H\u0097\bJ1\u0010\f\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J1\u0010\u0016\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0016\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010\u0016\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018H\u0007J1\u0010\u0019\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0019\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010\u0019\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J9\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00072\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u001cJ,\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u001a\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017JC\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u001eJ!\u0010\u001f\u001a\u00020\r2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010 J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0001H\u0007J\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u000fH\u0007J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0001H\u0007J\b\u0010#\u001a\u00020\rH\u0007J1\u0010$\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010$\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010$\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J1\u0010%\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010%\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010%\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J1\u0010&\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010&\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010&\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ltimber/log/Timber$Forest;", "Ltimber/log/Timber$Tree;", "()V", "treeArray", "", "[Ltimber/log/Timber$Tree;", "treeCount", "", "()I", "trees", "Ljava/util/ArrayList;", "asTree", "d", "", "message", "", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "t", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "e", "forest", "", "i", "log", "priority", "(ILjava/lang/String;[Ljava/lang/Object;)V", "tag", "(ILjava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "plant", "([Ltimber/log/Timber$Tree;)V", "tree", "uproot", "uprootAll", "v", "w", "wtf", "timber_release"}, k=1, mv={1, 5, 1}, xi=48)
    public static final class Forest
    extends Tree {
        private Forest() {
        }

        public /* synthetic */ Forest(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @JvmStatic
        public Tree asTree() {
            return this;
        }

        @Override
        @JvmStatic
        public void d(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].d(string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void d(Throwable throwable) {
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].d(throwable);
            }
        }

        @Override
        @JvmStatic
        public void d(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].d(throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void e(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].e(string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void e(Throwable throwable) {
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].e(throwable);
            }
        }

        @Override
        @JvmStatic
        public void e(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].e(throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @JvmStatic
        public final List<Tree> forest() {
            ArrayList arrayList = trees;
            synchronized (arrayList) {
                List<Tree> list = Collections.unmodifiableList(CollectionsKt.toList((Iterable)trees));
                Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(trees.toList())");
                return list;
            }
        }

        @Override
        @JvmStatic
        public void i(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].i(string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void i(Throwable throwable) {
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].i(throwable);
            }
        }

        @Override
        @JvmStatic
        public void i(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].i(throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        protected void log(int n, String string2, String string3, Throwable throwable) {
            Intrinsics.checkNotNullParameter(string3, "message");
            throw new AssertionError();
        }

        @Override
        @JvmStatic
        public void log(int n, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n2 = treeArray.length;
            for (int i = 0; i < n2; ++i) {
                treeArray[i].log(n, string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void log(int n, Throwable throwable) {
            Tree[] treeArray = treeArray;
            int n2 = treeArray.length;
            for (int i = 0; i < n2; ++i) {
                treeArray[i].log(n, throwable);
            }
        }

        @Override
        @JvmStatic
        public void log(int n, Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n2 = treeArray.length;
            for (int i = 0; i < n2; ++i) {
                treeArray[i].log(n, throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        public final void plant(Tree unit) {
            Intrinsics.checkNotNullParameter(unit, "tree");
            boolean bl = unit != this;
            if (!bl) {
                throw (Throwable)new IllegalArgumentException("Cannot plant Timber into itself.".toString());
            }
            ArrayList arrayList = trees;
            synchronized (arrayList) {
                trees.add(unit);
                unit = Forest;
                unit = ((Collection)trees).toArray(new Tree[0]);
                if (unit != null) {
                    Timber.treeArray = (Tree[])unit;
                    unit = Unit.INSTANCE;
                    return;
                }
                unit = new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                throw unit;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        public final void plant(Tree ... unit) {
            ArrayList arrayList;
            Intrinsics.checkNotNullParameter(unit, "trees");
            int n = ((Unit)unit).length;
            int n2 = 0;
            while (n2 < n) {
                arrayList = unit[n2];
                int n3 = n2 + 1;
                if (arrayList == null) {
                    throw (Throwable)new IllegalArgumentException("trees contained null".toString());
                }
                n2 = arrayList != this ? 1 : 0;
                if (n2 == 0) {
                    throw (Throwable)new IllegalArgumentException("Cannot plant Timber into itself.".toString());
                }
                n2 = n3;
            }
            arrayList = trees;
            synchronized (arrayList) {
                Collections.addAll(trees, Arrays.copyOf(unit, ((Unit)unit).length));
                unit = Forest;
                unit = ((Collection)trees).toArray(new Tree[0]);
                if (unit != null) {
                    Timber.treeArray = (Tree[])unit;
                    unit = Unit.INSTANCE;
                    return;
                }
                unit = new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                throw unit;
            }
        }

        @JvmStatic
        public final Tree tag(String string2) {
            Intrinsics.checkNotNullParameter(string2, "tag");
            for (Tree tree : treeArray) {
                tree.getExplicitTag$timber_release().set(string2);
            }
            return this;
        }

        @JvmStatic
        public final int treeCount() {
            return treeArray.length;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        public final void uproot(Tree treeArray) {
            Intrinsics.checkNotNullParameter(treeArray, "tree");
            ArrayList arrayList = trees;
            synchronized (arrayList) {
                if (!trees.remove(treeArray)) {
                    String string2 = Intrinsics.stringPlus("Cannot uproot tree which is not planted: ", treeArray);
                    treeArray = new IllegalArgumentException(string2.toString());
                    throw (Throwable)treeArray;
                }
                treeArray = Forest;
                treeArray = ((Collection)trees).toArray(new Tree[0]);
                if (treeArray != null) {
                    Timber.treeArray = treeArray;
                    treeArray = Unit.INSTANCE;
                    return;
                }
                treeArray = new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                throw treeArray;
            }
        }

        @JvmStatic
        public final void uprootAll() {
            ArrayList arrayList = trees;
            synchronized (arrayList) {
                trees.clear();
                Forest forest = Forest;
                Timber.treeArray = new Tree[0];
                forest = Unit.INSTANCE;
                return;
            }
        }

        @Override
        @JvmStatic
        public void v(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].v(string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void v(Throwable throwable) {
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].v(throwable);
            }
        }

        @Override
        @JvmStatic
        public void v(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].v(throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void w(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].w(string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void w(Throwable throwable) {
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].w(throwable);
            }
        }

        @Override
        @JvmStatic
        public void w(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].w(throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void wtf(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].wtf(string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }

        @Override
        @JvmStatic
        public void wtf(Throwable throwable) {
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].wtf(throwable);
            }
        }

        @Override
        @JvmStatic
        public void wtf(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            Tree[] treeArray = treeArray;
            int n = treeArray.length;
            for (int i = 0; i < n; ++i) {
                treeArray[i].wtf(throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
            }
        }
    }

    @Metadata(d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J/\u0010\u0014\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010\u0014\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J'\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0010\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000fH\u0014\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J/\u0010\u0018\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010\u0018\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0015J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J7\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ,\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H$J\u001a\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016JA\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fJA\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001fJ/\u0010!\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010!\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010!\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J/\u0010\"\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\"\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010\"\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J/\u0010#\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010#\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010#\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Ltimber/log/Timber$Tree;", "", "()V", "explicitTag", "Ljava/lang/ThreadLocal;", "", "getExplicitTag$timber_release", "()Ljava/lang/ThreadLocal;", "tag", "getTag$timber_release", "()Ljava/lang/String;", "d", "", "message", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "t", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "e", "formatMessage", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getStackTraceString", "i", "isLoggable", "", "priority", "", "log", "(ILjava/lang/String;[Ljava/lang/Object;)V", "(ILjava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "prepareLog", "v", "w", "wtf", "timber_release"}, k=1, mv={1, 5, 1}, xi=48)
    public static abstract class Tree {
        private final ThreadLocal<String> explicitTag = new ThreadLocal();

        private final String getStackTraceString(Throwable object) {
            StringWriter stringWriter = new StringWriter(256);
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
            ((Throwable)object).printStackTrace(printWriter);
            printWriter.flush();
            object = stringWriter.toString();
            Intrinsics.checkNotNullExpressionValue(object, "sw.toString()");
            return object;
        }

        private final void prepareLog(int n, Throwable throwable, String charSequence, Object ... objectArray) {
            String string2 = this.getTag$timber_release();
            if (!this.isLoggable(string2, n)) {
                return;
            }
            CharSequence charSequence2 = charSequence;
            boolean bl = false;
            boolean bl2 = charSequence2 == null || charSequence2.length() == 0;
            if (bl2) {
                if (throwable == null) {
                    return;
                }
                charSequence = this.getStackTraceString(throwable);
            } else {
                bl2 = bl;
                if (objectArray.length == 0) {
                    bl2 = true;
                }
                charSequence2 = charSequence;
                if (bl2 ^ true) {
                    charSequence2 = this.formatMessage((String)charSequence, objectArray);
                }
                charSequence = charSequence2;
                if (throwable != null) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((Object)charSequence2);
                    ((StringBuilder)charSequence).append('\n');
                    ((StringBuilder)charSequence).append(this.getStackTraceString(throwable));
                    charSequence = ((StringBuilder)charSequence).toString();
                }
            }
            this.log(n, string2, (String)charSequence, throwable);
        }

        public void d(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(3, null, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void d(Throwable throwable) {
            this.prepareLog(3, throwable, null, new Object[0]);
        }

        public void d(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(3, throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void e(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(6, null, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void e(Throwable throwable) {
            this.prepareLog(6, throwable, null, new Object[0]);
        }

        public void e(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(6, throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        protected String formatMessage(String string2, Object[] objectArray) {
            Intrinsics.checkNotNullParameter(string2, "message");
            Intrinsics.checkNotNullParameter(objectArray, "args");
            objectArray = Arrays.copyOf(objectArray, objectArray.length);
            string2 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(this, *args)");
            return string2;
        }

        public final /* synthetic */ ThreadLocal getExplicitTag$timber_release() {
            return this.explicitTag;
        }

        public /* synthetic */ String getTag$timber_release() {
            String string2 = this.explicitTag.get();
            if (string2 != null) {
                this.explicitTag.remove();
            }
            return string2;
        }

        public void i(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(4, null, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void i(Throwable throwable) {
            this.prepareLog(4, throwable, null, new Object[0]);
        }

        public void i(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(4, throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        @Deprecated(message="Use isLoggable(String, int)", replaceWith=@ReplaceWith(expression="this.isLoggable(null, priority)", imports={}))
        protected boolean isLoggable(int n) {
            return true;
        }

        protected boolean isLoggable(String string2, int n) {
            return this.isLoggable(n);
        }

        protected abstract void log(int var1, String var2, String var3, Throwable var4);

        public void log(int n, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(n, null, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void log(int n, Throwable throwable) {
            this.prepareLog(n, throwable, null, new Object[0]);
        }

        public void log(int n, Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(n, throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void v(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(2, null, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void v(Throwable throwable) {
            this.prepareLog(2, throwable, null, new Object[0]);
        }

        public void v(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(2, throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void w(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(5, null, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void w(Throwable throwable) {
            this.prepareLog(5, throwable, null, new Object[0]);
        }

        public void w(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(5, throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void wtf(String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(7, null, string2, Arrays.copyOf(objectArray, objectArray.length));
        }

        public void wtf(Throwable throwable) {
            this.prepareLog(7, throwable, null, new Object[0]);
        }

        public void wtf(Throwable throwable, String string2, Object ... objectArray) {
            Intrinsics.checkNotNullParameter(objectArray, "args");
            this.prepareLog(7, throwable, string2, Arrays.copyOf(objectArray, objectArray.length));
        }
    }
}

