//
// TinyPTC by Gaffer
// www.gaffer.org/tinyptc
//

#include "../../stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "../../tinyptc.h"
#include "Utils.h"


#define WIDTH 640
#define HEIGHT 480
#define SIZE WIDTH*HEIGHT

int noise;
int carry;
unsigned int x, y, position;
int seed = 0x12345;
union PIXEL pixel[SIZE];
int plasma[SIZE];
rgb palette[256];
int paletteShift = 0;


void generateRand()
{
	for (x = 0; x < SIZE; x++)
	{
		noise = seed;
		noise >>= 3;
		noise ^= seed;
		carry = noise & 1;
		noise >>= 1;
		seed >>= 1;
		seed |= (carry << 30);
		noise &= 0xFF;
		pixel[x].color = (noise << 16) | (noise << 8) | noise;
	}
}

void generateRandOneLine()
{
	for (x = 1; x < WIDTH; x++)
	{
		if (rand() % 2)
			pixel[x].color = 0xff;
		else
			pixel[x].color = 0;
	}
}

void generateMire()
{
	for (y = 0; y < HEIGHT; y++)
	{
		for (x = 0; x < WIDTH; x++)
		{
			position = (y*WIDTH) + x;
			pixel[position].color = 0xf << (x % 32);
		}
	}
}

void generatePlasma1()
{
	for (y = 0; y < HEIGHT; y++)
	{
		for (x = 0; x < WIDTH; x++)
		{
			noise = (int)(128.0 + (128.0 * sin(sqrt((x - WIDTH / 2.0) * (x - WIDTH / 2.0) + (y - HEIGHT / 2.0) * (y - HEIGHT / 2.0)) / 8.0)));
			//noise = (int)(128.0 + (128.0 * sin(x / 8.0)) + 128.0 + (128.0 * sin(y / 8.0))) / 2.0;
			position = (y*WIDTH) + x;
			pixel[position].color = (noise << 16) | (noise << 8) | noise;
		}
	}
}

void createPalette()
{
	//https://lodev.org/cgtutor/plasma.html
	for (int x = 0; x < 256; x++)
	{
		//use HSVtoRGB to vary the Hue of the color through the palette
		//palette[x] = hsv2rgb(MAKEHSV(x, 255, 255));

		palette[x].r = (unsigned char)(128.0 + 128 * sin(3.1415 * x / 32.0));
		palette[x].g = (unsigned char)(128.0 + 128 * sin(3.1415 * x / 64.0));
		palette[x].b = (unsigned char)(128.0 + 128 * sin(3.1415 * x / 128.0));
		/*palette[x].r = x;
		palette[x].g = 0;
		palette[x].b = 0;*/
		/*if (x >= 127 && x <= 129)
			palette[x] = MAKERGB(0xff, 0x5f, 0x00);
		else
			palette[x] = MAKERGB(0xff, 0xff, 0xff);*/
	}
}

void createPlasma()
{
	for (y = 0; y < HEIGHT; y++)
	{
		for (x = 0; x < WIDTH; x++)
		{
			/*noise = (int)((128.0 + (128.0 * sin(x / 16.0))
				+ 128.0 + (128.0 * sin(y / 16.0))
				) / 2.0);*/
			/*noise = (int)((
				128.0 + (128.0 * sin(x / 16.0))
				+ 128.0 + (128.0 * sin(y / 8.0))
				+ 128.0 + (128.0 * sin((x + y) / 16.0))
				+ 128.0 + (128.0 * sin(sqrt((double)(x * x + y * y)) / 8.0))) / 4.0);*/
			noise = (int)((
				128.0 + (128.0 * sin(x / 16.0))
				+ 128.0 + (128.0 * sin(y / 32.0))
				//+ 128.0 + (128.0 * sin(y / 32.0))
				+ 128.0 + (128.0 * sin(sqrt((double)((x - WIDTH / 2.0)* (x - WIDTH / 2.0) + (y - HEIGHT / 2.0) * (y - HEIGHT / 2.0))) / 8.0))
				+ 128.0 + (128.0 * sin(sqrt((double)(x * x + y * y)) / 8.0))) / 2.0);// / 4.0f
			position = (y*WIDTH) + x;
			plasma[position] = noise;
		}
	}
}

void generatePlasma2()
{
	if (seed++ > 0x10)
	{
		paletteShift++;
		seed = 0;
	}
	for (y = 0; y < HEIGHT; y++)
	{
		for (x = 0; x < WIDTH; x++)
		{
			position = (y*WIDTH) + x;
			pixel[position].colors = palette[(plasma[position] + paletteShift) % 256];
		}
	}
}

int main()
{
	/*union PIXEL pouet1;
	int pouet2;
	printf("%d %d", sizeof(pouet1), sizeof(pouet2));
	return 0;*/

	srand((unsigned int)time(NULL));
	if (!ptc_open("test", WIDTH, HEIGHT)) return 1;

	createPalette();
	createPlasma();

	while (1)
	{
		generatePlasma2();
		/*for (y = 0; y < HEIGHT; y++)
		{
			for (x = 0; x < WIDTH; x++)
			{
				position = (y*WIDTH) + x;
				pixel[position].colors = palette[x % 256];
				//pixel[position].color = plasma[position];
			}
		}*/
		ptc_update(pixel);
	}
}
