
#include "../../stdafx.h"
#include "Utils.h"

hsv rgb2hsv(rgb src)
{
	float r = src.r / 255.0f;
	float g = src.g / 255.0f;
	float b = src.b / 255.0f;

	float h, s, v; // h:0-360.0, s:0.0-1.0, v:0.0-1.0

	float max = max_f(r, g, b);
	float min = min_f(r, g, b);

	v = max;

	if (max == 0.0f) {
		s = 0;
		h = 0;
	}
	else if (max - min == 0.0f) {
		s = 0;
		h = 0;
	}
	else {
		s = (max - min) / max;

		if (max == r) {
			h = 60 * ((g - b) / (max - min)) + 0;
		}
		else if (max == g) {
			h = 60 * ((b - r) / (max - min)) + 120;
		}
		else {
			h = 60 * ((r - g) / (max - min)) + 240;
		}
	}

	if (h < 0) h += 360.0f;

	return MAKEHSV((unsigned char)(h / 2), (unsigned char)(s * 255), (unsigned char)(v * 255));
}

rgb hsv2rgb(hsv src)
{
	float h = src.h *   2.0f; // 0-360
	float s = src.s / 255.0f; // 0.0-1.0
	float v = src.v / 255.0f; // 0.0-1.0

	float r, g, b; // 0.0-1.0

	int   hi = (int)(h / 60.0f) % 6;
	float f = (h / 60.0f) - hi;
	float p = v * (1.0f - s);
	float q = v * (1.0f - s * f);
	float t = v * (1.0f - s * (1.0f - f));

	switch (hi) {
	case 0: r = v, g = t, b = p; break;
	case 1: r = q, g = v, b = p; break;
	case 2: r = p, g = v, b = t; break;
	case 3: r = p, g = q, b = v; break;
	case 4: r = t, g = p, b = v; break;
	case 5: r = v, g = p, b = q; break;
	}

	return MAKERGB((unsigned char)(r * 255), (unsigned char)(g * 255), (unsigned char)(b * 255));
}

