#ifndef __TINYPTC_TEST_UTILS_H
#define __TINYPTC_TEST_UTILS_H

#include <stdio.h>
#include <math.h>

#define MAKEHSV(ph, ps, pv)	((hsv) { .h = ph, .s = ps, .v = pv })
#define MAKERGB(pr, pg, pb)	((rgb) { .r = pr, .g = pg, .b = pb })
#define min_f(a, b, c)  (fminf(a, fminf(b, c)))
#define max_f(a, b, c)  (fmaxf(a, fmaxf(b, c)))

typedef struct {
	unsigned char b;
	unsigned char g;
	unsigned char r;
	unsigned char a;
} rgb;

typedef struct {
	unsigned char h;       // angle in degrees
	unsigned char s;
	unsigned char v;
} hsv;

union PIXEL
{
	rgb colors;
	int color;
};

hsv rgb2hsv(rgb src);
rgb hsv2rgb(hsv src);

#endif
